/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core.exclusions;

import com.getyourguide.openapi.validation.api.exclusions.ViolationExclusions;
import com.getyourguide.openapi.validation.api.model.Direction;
import com.getyourguide.openapi.validation.api.model.OpenApiViolation;
import lombok.Generated;

public class InternalViolationExclusions {
    private final ViolationExclusions customViolationExclusions;

    public boolean isExcluded(OpenApiViolation violation) {
        return this.falsePositive404(violation) || this.falsePositive405(violation) || this.falsePositive406(violation) || this.falsePositiveRequestWith4xxResponse(violation) || this.customViolationExclusions.isExcluded(violation) || InternalViolationExclusions.oneOfMatchesMoreThanOneSchema(violation) || this.isConcurrentModificationExceptionInLibrary(violation);
    }

    private static boolean oneOfMatchesMoreThanOneSchema(OpenApiViolation violation) {
        return ("validation.response.body.schema.oneOf".equals(violation.getRule()) || "validation.request.body.schema.oneOf".equals(violation.getRule())) && violation.getMessage().matches(".*Instance failed to match exactly one schema \\(matched [1-9][0-9]* out of \\d+\\).*");
    }

    private boolean falsePositive404(OpenApiViolation violation) {
        return ("validation.request.path.missing".equals(violation.getRule()) || "validation.request.operation.notAllowed".equals(violation.getRule())) && (violation.getDirection() == Direction.REQUEST && violation.getResponseStatus().isEmpty() || violation.getResponseStatus().orElse(0) == 404);
    }

    private boolean falsePositiveRequestWith4xxResponse(OpenApiViolation violation) {
        return violation.getDirection() == Direction.REQUEST && violation.getResponseStatus().orElse(0) >= 400 && violation.getResponseStatus().orElse(0) < 500;
    }

    private boolean falsePositive405(OpenApiViolation violation) {
        return violation.getResponseStatus().orElse(0) == 405 && "validation.request.operation.notAllowed".equals(violation.getRule());
    }

    private boolean falsePositive406(OpenApiViolation violation) {
        return violation.getResponseStatus().orElse(0) == 406 && "validation.response.status.unknown".equals(violation.getRule());
    }

    private boolean isConcurrentModificationExceptionInLibrary(OpenApiViolation violation) {
        return violation.getRule() != null && violation.getRule().endsWith(".body.schema.unknownError") && violation.getMessage().contains("java.util.ConcurrentModificationException");
    }

    @Generated
    public InternalViolationExclusions(ViolationExclusions customViolationExclusions) {
        this.customViolationExclusions = customViolationExclusions;
    }
}

