/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core.log;

import com.getyourguide.openapi.validation.api.log.OpenApiViolationHandler;
import com.getyourguide.openapi.validation.api.model.OpenApiViolation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.joda.time.DateTime;

public class ThrottlingOpenApiViolationHandler
implements OpenApiViolationHandler {
    private final OpenApiViolationHandler delegate;
    private final int waitSeconds;
    private final Map<String, DateTime> loggedMessages = new ConcurrentHashMap<String, DateTime>();

    public void onOpenApiViolation(OpenApiViolation violation) {
        if (this.isThrottled(violation)) {
            return;
        }
        this.delegate.onOpenApiViolation(violation);
        this.registerLoggedMessage(violation);
    }

    private void registerLoggedMessage(OpenApiViolation openApiViolation) {
        this.loggedMessages.put(this.buildKey(openApiViolation), DateTime.now());
    }

    private boolean isThrottled(OpenApiViolation openApiViolation) {
        String key = this.buildKey(openApiViolation);
        DateTime lastLoggedTime = this.loggedMessages.get(key);
        if (lastLoggedTime == null) {
            return false;
        }
        return lastLoggedTime.plusSeconds(this.waitSeconds).isAfterNow();
    }

    @NonNull
    private String buildKey(OpenApiViolation openApiViolation) {
        StringBuilder keyBuilder = new StringBuilder(openApiViolation.getDirection().toString() + ":");
        String method = openApiViolation.getRequestMetaData().getMethod();
        String apiOperationPathNormalized = openApiViolation.getNormalizedPath().orElse("N/A");
        String responseStatus = openApiViolation.getResponseStatus().map(Object::toString).orElse("N/A");
        String schema = openApiViolation.getSchema().orElse("N/A");
        keyBuilder.append(String.format("%s:%s:%s:%s", method, apiOperationPathNormalized, responseStatus, schema));
        return keyBuilder.toString();
    }

    @Generated
    public ThrottlingOpenApiViolationHandler(OpenApiViolationHandler delegate, int waitSeconds) {
        this.delegate = delegate;
        this.waitSeconds = waitSeconds;
    }
}

