/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core.mapper;

import com.atlassian.oai.validator.report.ValidationReport;
import com.getyourguide.openapi.validation.api.log.LogLevel;
import com.getyourguide.openapi.validation.api.model.Direction;
import com.getyourguide.openapi.validation.api.model.OpenApiViolation;
import com.getyourguide.openapi.validation.api.model.RequestMetaData;
import com.getyourguide.openapi.validation.api.model.ResponseMetaData;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class ValidationReportToOpenApiViolationsMapper {
    public List<OpenApiViolation> map(ValidationReport validationReport, RequestMetaData request, @Nullable ResponseMetaData response, Direction direction, String body) {
        return validationReport.getMessages().stream().map(message -> this.buildOpenApiViolation((ValidationReport.Message)message, request, response, body, direction)).toList();
    }

    private OpenApiViolation buildOpenApiViolation(ValidationReport.Message message, RequestMetaData request, @Nullable ResponseMetaData response, String body, Direction direction) {
        String requestUri = request.getUri().toString();
        String requestString = String.format("%s %s", request.getMethod(), requestUri);
        Optional<String> pointersInstance = ValidationReportToOpenApiViolationsMapper.getPointersInstance(message);
        String instance = pointersInstance.map(i -> String.format("Instance: %s\n", i)).orElse("");
        Optional<String> parameterName = ValidationReportToOpenApiViolationsMapper.getParameterName(message);
        String parameter = parameterName.map(i -> String.format("Parameter: %s\n", i)).orElse("");
        String responseStatusCode = response != null ? String.format("Response Status Code: %s\n", response.getStatusCode()) : "";
        String logMessage = String.format("OpenAPI spec validation error [%s]\n%s\nUser Agent: %s\n%s%s%s\n%s", message.getKey(), requestString, request.getHeaders().get("User-Agent"), responseStatusCode, instance, parameter, message);
        return OpenApiViolation.builder().level(this.mapLogLevel(message.getLevel())).direction(direction).requestMetaData(request).body(body).rule(message.getKey()).operationId((String)ValidationReportToOpenApiViolationsMapper.getOperationId(message).orElse(null)).normalizedPath((String)ValidationReportToOpenApiViolationsMapper.getNormalizedPath(message).orElse(null)).instance((String)pointersInstance.orElse(null)).parameter((String)parameterName.orElse(null)).schema((String)ValidationReportToOpenApiViolationsMapper.getPointersSchema(message).orElse(null)).responseStatus((Integer)ValidationReportToOpenApiViolationsMapper.getResponseStatus(response, message).orElse(null)).logMessage(logMessage).message(message.getMessage()).build();
    }

    private static Optional<String> getPointersInstance(ValidationReport.Message message) {
        return message.getContext().flatMap(ValidationReport.MessageContext::getPointers).map(ValidationReport.MessageContext.Pointers::getInstance);
    }

    private static Optional<String> getPointersSchema(ValidationReport.Message message) {
        return message.getContext().flatMap(ValidationReport.MessageContext::getPointers).map(ValidationReport.MessageContext.Pointers::getSchema);
    }

    private static Optional<String> getParameterName(ValidationReport.Message message) {
        return message.getContext().flatMap(ValidationReport.MessageContext::getParameter).map(Parameter::getName);
    }

    private static Optional<String> getOperationId(ValidationReport.Message message) {
        return message.getContext().flatMap(ValidationReport.MessageContext::getApiOperation).map(apiOperation -> apiOperation.getOperation().getOperationId());
    }

    private static Optional<String> getNormalizedPath(ValidationReport.Message message) {
        return message.getContext().flatMap(ValidationReport.MessageContext::getApiOperation).map(apiOperation -> apiOperation.getApiPath().normalised());
    }

    private static Optional<Integer> getResponseStatus(@Nullable ResponseMetaData response, ValidationReport.Message message) {
        if (response != null && response.getStatusCode() != null) {
            return Optional.of(response.getStatusCode());
        }
        return message.getContext().flatMap(ValidationReport.MessageContext::getResponseStatus);
    }

    private LogLevel mapLogLevel(ValidationReport.Level level) {
        if (level == null) {
            return null;
        }
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case ValidationReport.Level.ERROR -> LogLevel.ERROR;
            case ValidationReport.Level.WARN -> LogLevel.WARN;
            case ValidationReport.Level.INFO -> LogLevel.INFO;
            case ValidationReport.Level.IGNORE -> LogLevel.IGNORE;
        };
    }
}

