/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core.metrics;

import com.getyourguide.openapi.validation.api.log.LogLevel;
import com.getyourguide.openapi.validation.api.metrics.MetricTag;
import com.getyourguide.openapi.validation.api.metrics.MetricTagProvider;
import com.getyourguide.openapi.validation.api.metrics.MetricsReporter;
import com.getyourguide.openapi.validation.api.metrics.client.MetricsClient;
import com.getyourguide.openapi.validation.api.model.OpenApiViolation;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class DefaultMetricsReporter
implements MetricsReporter {
    private final MetricsClient metricsClient;
    private final MetricTagProvider metricTagProvider;
    private final Configuration configuration;

    public void reportViolation(OpenApiViolation violation) {
        if (violation.getLevel() == LogLevel.IGNORE) {
            return;
        }
        this.metricsClient.increment(this.buildMetricName(".error"), this.createTagsForViolation(violation));
    }

    public void reportStartup(boolean isValidationEnabled, double sampleRate, int validationReportThrottleWaitSeconds) {
        this.metricsClient.increment(this.buildMetricName(".startup"), this.createTagsForStartup(isValidationEnabled, sampleRate, validationReportThrottleWaitSeconds));
    }

    private String buildMetricName(String suffix) {
        return this.configuration.getMetricName() + suffix;
    }

    private MetricTag[] createTagsForViolation(OpenApiViolation violation) {
        ArrayList<MetricTag> tags = new ArrayList<MetricTag>();
        tags.add(new MetricTag("type", violation.getDirection().toString().toLowerCase()));
        tags.add(new MetricTag("method", violation.getRequestMetaData().getMethod().toLowerCase()));
        violation.getNormalizedPath().ifPresent(path -> tags.add(new MetricTag("path", path)));
        violation.getResponseStatus().ifPresent(responseStatus -> tags.add(new MetricTag("status", responseStatus.toString())));
        tags.addAll(this.getMetricTagsFromConfiguration());
        tags.addAll(this.metricTagProvider.getTagsForViolation(violation));
        return (MetricTag[])tags.toArray(MetricTag[]::new);
    }

    private MetricTag[] createTagsForStartup(boolean isValidationEnabled, double sampleRate, int validationReportThrottleWaitSeconds) {
        ArrayList<MetricTag> tags = new ArrayList<MetricTag>();
        tags.add(new MetricTag("validation_enabled", String.valueOf(isValidationEnabled)));
        tags.add(new MetricTag("sample_rate", String.valueOf(sampleRate)));
        tags.add(new MetricTag("throttling", String.valueOf(validationReportThrottleWaitSeconds)));
        tags.addAll(this.getMetricTagsFromConfiguration());
        return (MetricTag[])tags.toArray(MetricTag[]::new);
    }

    private List<MetricTag> getMetricTagsFromConfiguration() {
        if (this.configuration.getMetricAdditionalTags() != null) {
            return this.configuration.getMetricAdditionalTags();
        }
        return List.of();
    }

    @Generated
    public DefaultMetricsReporter(MetricsClient metricsClient, MetricTagProvider metricTagProvider, Configuration configuration) {
        this.metricsClient = metricsClient;
        this.metricTagProvider = metricTagProvider;
        this.configuration = configuration;
    }

    public static class Configuration {
        private final String metricName;
        private final List<MetricTag> metricAdditionalTags;

        @Generated
        Configuration(String metricName, List<MetricTag> metricAdditionalTags) {
            this.metricName = metricName;
            this.metricAdditionalTags = metricAdditionalTags;
        }

        @Generated
        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        @Generated
        public String getMetricName() {
            return this.metricName;
        }

        @Generated
        public List<MetricTag> getMetricAdditionalTags() {
            return this.metricAdditionalTags;
        }

        @Generated
        public static class ConfigurationBuilder {
            @Generated
            private String metricName;
            @Generated
            private List<MetricTag> metricAdditionalTags;

            @Generated
            ConfigurationBuilder() {
            }

            @Generated
            public ConfigurationBuilder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            @Generated
            public ConfigurationBuilder metricAdditionalTags(List<MetricTag> metricAdditionalTags) {
                this.metricAdditionalTags = metricAdditionalTags;
                return this;
            }

            @Generated
            public Configuration build() {
                return new Configuration(this.metricName, this.metricAdditionalTags);
            }

            @Generated
            public String toString() {
                return "DefaultMetricsReporter.Configuration.ConfigurationBuilder(metricName=" + this.metricName + ", metricAdditionalTags=" + this.metricAdditionalTags + ")";
            }
        }
    }
}

