/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.core.validator;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.getyourguide.openapi.validation.core.validator.OpenApiInteractionValidatorWrapper;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class MultipleSpecOpenApiInteractionValidatorWrapper
implements OpenApiInteractionValidatorWrapper {
    public static final String MESSAGE_KEY_NO_VALIDATOR_FOUND = "openapi-validator-java.noValidatorFound";
    private final List<Pair<Pattern, OpenApiInteractionValidatorWrapper>> validators;

    public MultipleSpecOpenApiInteractionValidatorWrapper(List<Pair<Pattern, OpenApiInteractionValidatorWrapper>> validators) {
        assert (validators != null && validators.size() > 0);
        this.validators = validators;
    }

    @Override
    public ValidationReport validateRequest(SimpleRequest request) {
        return this.getValidatorForPath(request.getPath()).map(validator -> validator.validateRequest(request)).orElse(new SimpleValidationReport(List.of(MultipleSpecOpenApiInteractionValidatorWrapper.buildNoValidatorFoundMessage(request.getPath()))));
    }

    @Override
    public ValidationReport validateResponse(String path, Request.Method method, SimpleResponse response) {
        return this.getValidatorForPath(path).map(validator -> validator.validateResponse(path, method, response)).orElse(new SimpleValidationReport(List.of(MultipleSpecOpenApiInteractionValidatorWrapper.buildNoValidatorFoundMessage(path))));
    }

    private Optional<OpenApiInteractionValidatorWrapper> getValidatorForPath(String path) {
        for (Pair<Pattern, OpenApiInteractionValidatorWrapper> validator : this.validators) {
            if (!((Pattern)validator.getLeft()).matcher(path).matches()) continue;
            return validator.getRight() != null ? Optional.of((OpenApiInteractionValidatorWrapper)validator.getRight()) : Optional.empty();
        }
        return Optional.empty();
    }

    private static SimpleMessage buildNoValidatorFoundMessage(String path) {
        return new SimpleMessage(MESSAGE_KEY_NO_VALIDATOR_FOUND, "ValidatorConfiguration has no spec file matching path: " + path, ValidationReport.Level.WARN);
    }

    private static class SimpleValidationReport
    implements ValidationReport {
        private final List<ValidationReport.Message> messages;

        @Nonnull
        public List<ValidationReport.Message> getMessages() {
            return this.messages;
        }

        public ValidationReport withAdditionalContext(ValidationReport.MessageContext context) {
            return this;
        }

        @Generated
        public SimpleValidationReport(List<ValidationReport.Message> messages) {
            this.messages = messages;
        }
    }

    private static class SimpleMessage
    implements ValidationReport.Message {
        private final String key;
        private final String message;
        private final ValidationReport.Level level;

        public String getKey() {
            return this.key;
        }

        public String getMessage() {
            return this.message;
        }

        public ValidationReport.Level getLevel() {
            return this.level;
        }

        public List<String> getAdditionalInfo() {
            return List.of();
        }

        public Optional<ValidationReport.MessageContext> getContext() {
            return Optional.empty();
        }

        public ValidationReport.Message withLevel(ValidationReport.Level level) {
            return this;
        }

        public ValidationReport.Message withAdditionalInfo(String info) {
            return this;
        }

        public ValidationReport.Message withAdditionalContext(ValidationReport.MessageContext context) {
            return this;
        }

        public String toString() {
            return this.message;
        }

        @Generated
        public SimpleMessage(String key, String message, ValidationReport.Level level) {
            this.key = key;
            this.message = message;
            this.level = level;
        }
    }
}

