/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.common;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.common.UIntBase;
import com.github.DNAProject.core.program.Program;
import com.github.DNAProject.core.scripts.ScriptBuilder;
import com.github.DNAProject.core.scripts.ScriptOp;
import com.github.DNAProject.crypto.Base58;
import com.github.DNAProject.crypto.Digest;
import com.github.DNAProject.sdk.exception.SDKException;

public class Address
extends UIntBase
implements Comparable<Address> {
    public static final Address ZERO = new Address();
    public static final byte COIN_VERSION = 23;

    public Address() {
        this(null);
    }

    public Address(byte[] value) {
        super(20, value);
    }

    public static Address parse(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.startsWith("0x")) {
            value = value.substring(2);
        }
        if (value.length() != 40) {
            throw new IllegalArgumentException();
        }
        byte[] v = Helper.hexToBytes(value);
        return new Address(v);
    }

    public static boolean tryParse(String s, Address result) {
        try {
            Address v = Address.parse(s);
            result.data_bytes = v.data_bytes;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Address AddressFromVmCode(String codeHexStr) {
        Address code = Address.toScriptHash(Helper.hexToBytes(codeHexStr));
        return code;
    }

    public static Address addressFromPubKey(String publicKey) {
        return Address.addressFromPubKey(Helper.hexToBytes(publicKey));
    }

    public static Address addressFromPubKey(byte[] publicKey) {
        ScriptBuilder sb = new ScriptBuilder();
        sb.emitPushByteArray(publicKey);
        sb.add(ScriptOp.OP_CHECKSIG);
        return Address.toScriptHash(sb.toArray());
    }

    public static Address addressFromMultiPubKeys(int m, byte[] ... publicKeys) throws Exception {
        return Address.toScriptHash(Program.ProgramFromMultiPubKey(m, publicKeys));
    }

    public static Address decodeBase58(String address) throws SDKException {
        byte[] data = new byte[]{};
        try {
            data = Base58.decode(address);
        }
        catch (Exception e) {
            throw new SDKException(ErrorCode.ParamError);
        }
        if (data.length != 25) {
            throw new SDKException(ErrorCode.ParamError);
        }
        if (data[0] != 23) {
            throw new SDKException(ErrorCode.ParamError);
        }
        byte[] checksum = Digest.sha256(Digest.sha256(data, 0, 21));
        for (int i = 0; i < 4; ++i) {
            if (data[data.length - 4 + i] == checksum[i]) continue;
            throw new SDKException(ErrorCode.ParamError);
        }
        byte[] buffer = new byte[20];
        System.arraycopy(data, 1, buffer, 0, 20);
        return new Address(buffer);
    }

    public static Address toScriptHash(byte[] script) {
        return new Address(Digest.hash160(script));
    }

    @Override
    public int compareTo(Address other) {
        byte[] x = this.data_bytes;
        byte[] y = other.data_bytes;
        for (int i = x.length - 1; i >= 0; --i) {
            int r = Byte.toUnsignedInt(x[i]) - Byte.toUnsignedInt(y[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public String toBase58() {
        byte[] data = new byte[25];
        data[0] = 23;
        System.arraycopy(this.toArray(), 0, data, 1, 20);
        byte[] checksum = Digest.sha256(Digest.sha256(data, 0, 21));
        System.arraycopy(checksum, 0, data, 21, 4);
        return Base58.encode(data);
    }
}

