/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.common;

import com.github.DNAProject.common.Helper;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public abstract class UIntBase
implements Serializable {
    protected byte[] data_bytes;

    protected UIntBase(int bytes, byte[] value) {
        if (value == null) {
            this.data_bytes = new byte[bytes];
            return;
        }
        if (value.length != bytes) {
            throw new IllegalArgumentException();
        }
        this.data_bytes = value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UIntBase)) {
            return false;
        }
        UIntBase other = (UIntBase)obj;
        return Arrays.equals(this.data_bytes, other.data_bytes);
    }

    public int hashCode() {
        return ByteBuffer.wrap(this.data_bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    @Override
    public byte[] toArray() {
        return this.data_bytes;
    }

    public String toString() {
        return Helper.toHexString(Helper.reverse(this.data_bytes));
    }

    @Override
    public String toHexString() {
        return Helper.reverse(Helper.toHexString(this.toArray()));
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.write(this.data_bytes);
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        reader.read(this.data_bytes);
    }
}

