/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.asset;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Contract
implements Serializable {
    public byte version;
    public Address constracHash;
    public String method;
    public byte[] args;

    public Contract() {
    }

    public Contract(byte version, Address constracHash, String method, byte[] args) {
        this.version = version;
        this.constracHash = constracHash;
        this.method = method;
        this.args = args;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        try {
            this.version = reader.readByte();
            this.constracHash = reader.readSerializable(Address.class);
            this.method = new String(reader.readVarBytes());
            this.args = reader.readVarBytes();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeByte(this.version);
        writer.writeSerializable(this.constracHash);
        writer.writeVarBytes(this.method.getBytes());
        writer.writeVarBytes(this.args);
    }

    public static Contract deserializeFrom(byte[] value) throws IOException {
        try {
            int offset = 0;
            ByteArrayInputStream ms = new ByteArrayInputStream(value, offset, value.length - offset);
            BinaryReader reader = new BinaryReader(ms);
            Contract contract = new Contract();
            contract.deserialize(reader);
            return contract;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }
}

