/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.asset;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;

public class State
implements Serializable {
    public Address from;
    public Address to;
    public long value;

    public State() {
    }

    public State(Address from, Address to, long amount) {
        this.from = from;
        this.to = to;
        this.value = amount;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        this.from = new Address(reader.readVarBytes());
        this.to = new Address(reader.readVarBytes());
        this.value = Helper.BigIntFromNeoBytes(reader.readVarBytes()).longValue();
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(this.from.toArray());
        writer.writeVarBytes(this.to.toArray());
        writer.writeVarBytes(Helper.BigIntToNeoBytes(BigInteger.valueOf(this.value)));
    }

    public static State deserializeFrom(byte[] value) throws IOException {
        try {
            int offset = 0;
            ByteArrayInputStream ms = new ByteArrayInputStream(value, offset, value.length - offset);
            BinaryReader reader = new BinaryReader(ms);
            State state = new State();
            state.deserialize(reader);
            return state;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }

    public Object json() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("from", this.from.toHexString());
        json.put("to", this.to.toHexString());
        json.put("value", this.value);
        return json;
    }
}

