/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.asset;

import com.github.DNAProject.core.asset.State;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Transfers
implements Serializable {
    public State[] states;

    public Transfers() {
    }

    public Transfers(State[] states) {
        this.states = states;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        int len = (int)reader.readVarInt();
        this.states = new State[len];
        for (int i = 0; i < len; ++i) {
            try {
                this.states[i] = reader.readSerializable(State.class);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeSerializableArray(this.states);
    }

    public static Transfers deserializeFrom(byte[] value) throws IOException {
        try {
            int offset = 0;
            ByteArrayInputStream ms = new ByteArrayInputStream(value, offset, value.length - offset);
            BinaryReader reader = new BinaryReader(ms);
            Transfers transfers = new Transfers();
            transfers.deserialize(reader);
            return transfers;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }

    public Object json() {
        HashMap json = new HashMap();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.states.length; ++i) {
            list.add(this.states[i].json());
        }
        json.put("States", list);
        return json;
    }
}

