/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.governance;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.io.Serializable;
import java.io.IOException;
import java.util.HashMap;

public class PeerPoolItem
implements Serializable {
    public int index;
    public String peerPubkey;
    public Address address;
    public int status;
    public long initPos;
    public long totalPos;

    public PeerPoolItem() {
    }

    public PeerPoolItem(int index, String peerPubkey, Address address, int status, long initPos, long totalPos) {
        this.index = index;
        this.peerPubkey = peerPubkey;
        this.address = address;
        this.status = status;
        this.initPos = initPos;
        this.totalPos = totalPos;
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        this.index = reader.readInt();
        this.peerPubkey = reader.readVarString();
        try {
            this.address = reader.readSerializable(Address.class);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.status = reader.readByte();
        this.initPos = reader.readLong();
        this.totalPos = reader.readLong();
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeInt(this.index);
        writer.writeVarString(this.peerPubkey);
        writer.writeSerializable(this.address);
        writer.writeByte((byte)this.status);
        writer.writeLong(this.initPos);
        writer.writeLong(this.totalPos);
    }

    public Object Json() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("index", this.index);
        map.put("peerPubkey", this.peerPubkey);
        map.put("address", this.address.toBase58());
        map.put("status", this.status);
        map.put("initPos", this.initPos);
        map.put("totalPos", this.totalPos);
        return map;
    }
}

