/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.payload;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.VmType;
import com.github.DNAProject.core.transaction.Attribute;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.core.transaction.TransactionType;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import java.io.IOException;
import java.util.Random;

public class DeployWasmCode
extends Transaction {
    public byte[] code;
    public VmType vmType = VmType.WASMVM;
    public String name;
    public String version;
    public String author;
    public String email;
    public String description;

    public DeployWasmCode() {
        super(TransactionType.DeployCode);
    }

    public DeployWasmCode(String codeStr, String name, String codeVersion, String author, String email, String description, Address payer, long gasLimit, long gasPrice) {
        super(TransactionType.DeployCode);
        this.attributes = new Attribute[0];
        this.code = Helper.hexToBytes(codeStr);
        this.name = name;
        this.version = codeVersion;
        this.author = author;
        this.email = email;
        this.nonce = new Random().nextInt();
        this.description = description;
        if (payer != null) {
            this.payer = payer;
        }
        this.gasLimit = gasLimit;
        this.gasPrice = gasPrice;
    }

    @Override
    public void deserializeExclusiveData(BinaryReader reader) throws IOException {
        try {
            this.code = reader.readVarBytes();
            this.vmType = VmType.valueOf(reader.readByte());
            this.name = reader.readVarString();
            this.version = reader.readVarString();
            this.author = reader.readVarString();
            this.email = reader.readVarString();
            this.description = reader.readVarString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void serializeExclusiveData(BinaryWriter writer) throws IOException {
        writer.writeVarBytes(this.code);
        writer.writeByte(this.vmType.value());
        writer.writeVarString(this.name);
        writer.writeVarString(this.version);
        writer.writeVarString(this.author);
        writer.writeVarString(this.email);
        writer.writeVarString(this.description);
    }
}

