/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.core.transaction;

import com.github.DNAProject.common.Address;
import com.github.DNAProject.core.Inventory;
import com.github.DNAProject.core.InventoryType;
import com.github.DNAProject.core.asset.Sig;
import com.github.DNAProject.core.transaction.Attribute;
import com.github.DNAProject.core.transaction.TransactionType;
import com.github.DNAProject.io.BinaryReader;
import com.github.DNAProject.io.BinaryWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public abstract class Transaction
extends Inventory {
    public byte version = 0;
    public TransactionType txType;
    public int nonce = new Random().nextInt();
    public long gasPrice = 0L;
    public long gasLimit = 0L;
    public Address payer = new Address();
    public Attribute[] attributes;
    public Sig[] sigs = new Sig[0];

    protected Transaction(TransactionType type) {
        this.txType = type;
    }

    public static Transaction deserializeFrom(byte[] value) throws IOException {
        return Transaction.deserializeFrom(value, 0);
    }

    /*
     * Exception decompiling
     */
    public static Transaction deserializeFrom(byte[] value, int offset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Transaction deserializeFrom(BinaryReader reader) throws IOException {
        try {
            byte ver = reader.readByte();
            TransactionType type = TransactionType.valueOf(reader.readByte());
            String typeName = "com.github.DNAProject.core.payload." + type.toString();
            Transaction transaction = (Transaction)Class.forName(typeName).newInstance();
            transaction.nonce = reader.readInt();
            transaction.version = ver;
            transaction.gasPrice = reader.readLong();
            transaction.gasLimit = reader.readLong();
            transaction.payer = reader.readSerializable(Address.class);
            transaction.deserializeUnsignedWithoutType(reader);
            transaction.sigs = new Sig[(int)reader.readVarInt()];
            for (int i = 0; i < transaction.sigs.length; ++i) {
                transaction.sigs[i] = reader.readSerializable(Sig.class);
            }
            return transaction;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void deserialize(BinaryReader reader) throws IOException {
        this.deserializeUnsigned(reader);
        try {
            this.sigs = (Sig[])reader.readSerializableArray(Sig.class);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void deserializeUnsigned(BinaryReader reader) throws IOException {
        this.txType = TransactionType.valueOf(reader.readByte());
        this.nonce = reader.readInt();
        this.version = reader.readByte();
        this.gasPrice = reader.readLong();
        this.gasLimit = reader.readLong();
        try {
            this.payer = reader.readSerializable(Address.class);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.deserializeUnsignedWithoutType(reader);
    }

    private void deserializeUnsignedWithoutType(BinaryReader reader) throws IOException {
        try {
            this.deserializeExclusiveData(reader);
            this.attributes = (Attribute[])reader.readSerializableArray(Attribute.class);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IOException(ex);
        }
    }

    protected void deserializeExclusiveData(BinaryReader reader) throws IOException {
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        this.serializeUnsigned(writer);
        writer.writeSerializableArray(this.sigs);
    }

    @Override
    public void serializeUnsigned(BinaryWriter writer) throws IOException {
        writer.writeByte(this.version);
        writer.writeByte(this.txType.value());
        writer.writeInt(this.nonce);
        writer.writeLong(this.gasPrice);
        writer.writeLong(this.gasLimit);
        writer.writeSerializable(this.payer);
        this.serializeExclusiveData(writer);
        writer.writeSerializableArray(this.attributes);
    }

    protected void serializeExclusiveData(BinaryWriter writer) throws IOException {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        Transaction tx = (Transaction)obj;
        return this.hash().equals(tx.hash());
    }

    public int hashCode() {
        return this.hash().hashCode();
    }

    @Override
    public Address[] getAddressU160ForVerifying() {
        return null;
    }

    @Override
    public final InventoryType inventoryType() {
        return InventoryType.TX;
    }

    public Object json() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("Hash", this.hash().toString());
        json.put("Version", Integer.valueOf(this.version));
        json.put("Nonce", this.nonce & 0xFFFFFFFF);
        json.put("TxType", this.txType.value() & 0xFF);
        json.put("GasPrice", this.gasPrice);
        json.put("GasLimit", this.gasLimit);
        json.put("Payer", this.payer.toBase58());
        json.put("Attributes", Arrays.stream(this.attributes).map(p -> p.json()).toArray(Object[]::new));
        json.put("Sigs", Arrays.stream(this.sigs).map(p -> p.json()).toArray(Object[]::new));
        return json;
    }

    @Override
    public boolean verify() {
        return true;
    }
}

