/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.crypto.Digest;
import com.github.DNAProject.sdk.exception.SDKException;
import java.math.BigInteger;
import java.util.Arrays;

public class Base58 {
    public static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final BigInteger BASE = BigInteger.valueOf("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".length());

    public static byte[] decode(String input) {
        int leadingZeros;
        BigInteger bi = BigInteger.ZERO;
        for (int i = input.length() - 1; i >= 0; --i) {
            int index = ALPHABET.indexOf(input.charAt(i));
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            bi = bi.add(BASE.pow(input.length() - 1 - i).multiply(BigInteger.valueOf(index)));
        }
        byte[] bytes = bi.toByteArray();
        boolean stripSignByte = bytes.length > 1 && bytes[0] == 0 && bytes[1] < 0;
        for (leadingZeros = 0; leadingZeros < input.length() && input.charAt(leadingZeros) == ALPHABET.charAt(0); ++leadingZeros) {
        }
        byte[] tmp = new byte[bytes.length - (stripSignByte ? 1 : 0) + leadingZeros];
        System.arraycopy(bytes, stripSignByte ? 1 : 0, tmp, leadingZeros, tmp.length - leadingZeros);
        return tmp;
    }

    public static String encode(byte[] input) {
        BigInteger value = new BigInteger(1, input);
        StringBuilder sb = new StringBuilder();
        while (value.compareTo(BASE) >= 0) {
            BigInteger[] r = value.divideAndRemainder(BASE);
            sb.insert(0, ALPHABET.charAt(r[1].intValue()));
            value = r[0];
        }
        sb.insert(0, ALPHABET.charAt(value.intValue()));
        for (byte b : input) {
            if (b != 0) break;
            sb.insert(0, ALPHABET.charAt(0));
        }
        return sb.toString();
    }

    public static String checkSumEncode(byte[] in) {
        byte[] hash = Digest.sha256(Digest.sha256(in));
        byte[] checksum = Arrays.copyOfRange(hash, 0, 4);
        byte[] input = new byte[in.length + 4];
        System.arraycopy(in, 0, input, 0, in.length);
        System.arraycopy(checksum, 0, input, in.length, 4);
        return Base58.encode(input);
    }

    public static byte[] decodeChecked(String input) throws Exception {
        byte[] actualChecksum;
        byte[] decoded = Base58.decode(input);
        if (decoded.length < 4) {
            throw new Exception(ErrorCode.InputTooShort);
        }
        byte[] data = Arrays.copyOfRange(decoded, 0, decoded.length - 4);
        byte[] checksum = Arrays.copyOfRange(decoded, decoded.length - 4, decoded.length);
        if (!Arrays.equals(checksum, actualChecksum = Arrays.copyOfRange(Digest.sha256(Digest.sha256(data)), 0, 4))) {
            throw new SDKException(ErrorCode.ChecksumNotValidate);
        }
        return decoded;
    }
}

