/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.crypto;

import com.github.DNAProject.common.ErrorCode;

public enum KeyType {
    ECDSA(18),
    SM2(19),
    EDDSA(20);

    private int label;

    private KeyType(int b) {
        this.label = b;
    }

    public static KeyType fromLabel(byte label) throws Exception {
        for (KeyType k : KeyType.values()) {
            if (k.label != label) continue;
            return k;
        }
        throw new Exception(ErrorCode.UnknownAsymmetricKeyType);
    }

    public static KeyType fromPubkey(byte[] pubkey) {
        try {
            if (pubkey.length == 33) {
                return ECDSA;
            }
            return KeyType.fromLabel(pubkey[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLabel() {
        return this.label;
    }
}

