/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.io;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.core.scripts.ScriptOp;
import com.github.DNAProject.crypto.ECC;
import com.github.DNAProject.io.Serializable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bouncycastle.math.ec.ECPoint;

public class BinaryReader
implements AutoCloseable {
    private DataInputStream reader;
    private byte[] array = new byte[8];
    private ByteBuffer buffer = ByteBuffer.wrap(this.array).order(ByteOrder.LITTLE_ENDIAN);

    public BinaryReader(InputStream stream) {
        this.reader = new DataInputStream(stream);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void read(byte[] buffer) throws IOException {
        this.reader.readFully(buffer);
    }

    public void read(byte[] buffer, int index, int length) throws IOException {
        this.reader.readFully(buffer, index, length);
    }

    public boolean readBoolean() throws IOException {
        return this.reader.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.reader.readByte();
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] buffer = new byte[count];
        this.reader.readFully(buffer);
        return buffer;
    }

    public double readDouble() throws IOException {
        this.reader.readFully(this.array, 0, 8);
        return this.buffer.getDouble(0);
    }

    public ECPoint readECPoint() throws IOException {
        byte[] encoded;
        byte fb = this.reader.readByte();
        switch (fb) {
            case 0: {
                encoded = new byte[1];
                break;
            }
            case 2: 
            case 3: {
                encoded = new byte[33];
                encoded[0] = fb;
                this.reader.readFully(encoded, 1, 32);
                break;
            }
            case 4: {
                encoded = new byte[65];
                encoded[0] = fb;
                this.reader.readFully(encoded, 1, 64);
                break;
            }
            default: {
                throw new IOException(ErrorCode.ParamError);
            }
        }
        return ECC.secp256r1.getCurve().decodePoint(encoded);
    }

    public String readFixedString(int length) throws IOException {
        byte[] data = this.readBytes(length);
        int count = -1;
        while (data[++count] != 0) {
        }
        return new String(data, 0, count, "UTF-8");
    }

    public float readFloat() throws IOException {
        this.reader.readFully(this.array, 0, 4);
        return this.buffer.getFloat(0);
    }

    public int readInt() throws IOException {
        this.reader.readFully(this.array, 0, 4);
        return this.buffer.getInt(0);
    }

    public long readLong() throws IOException {
        this.reader.readFully(this.array, 0, 8);
        return this.buffer.getLong(0);
    }

    public <T extends Serializable> T readSerializable(Class<T> t) throws InstantiationException, IllegalAccessException, IOException {
        Serializable obj = (Serializable)t.newInstance();
        obj.deserialize(this);
        return (T)obj;
    }

    public <T extends Serializable> T[] readSerializableArray(Class<T> t) throws InstantiationException, IllegalAccessException, IOException {
        Serializable[] array = (Serializable[])Array.newInstance(t, (int)this.readVarInt(0x10000000L));
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Serializable)t.newInstance();
            array[i].deserialize(this);
        }
        return array;
    }

    public short readShort() throws IOException {
        this.reader.readFully(this.array, 0, 2);
        return this.buffer.getShort(0);
    }

    public byte[] readVarBytes() throws IOException {
        return this.readVarBytes(0x7FFFFFC7);
    }

    public byte[] readVarBytes2() throws IOException {
        return this.readBytes((int)this.readVarInt2(0x7FFFFFC7L));
    }

    public byte[] readVarBytes(int max) throws IOException {
        return this.readBytes((int)this.readVarInt(max));
    }

    public long readVarInt() throws IOException {
        return this.readVarInt(Long.MAX_VALUE);
    }

    public long readVarInt(long max) throws IOException {
        long fb = Byte.toUnsignedLong(this.readByte());
        long value = fb == 253L ? Short.toUnsignedLong(this.readShort()) : (fb == 254L ? Integer.toUnsignedLong(this.readInt()) : (fb == 255L ? this.readLong() : fb));
        if (Long.compareUnsigned(value, max) > 0) {
            throw new IOException(ErrorCode.ParamError);
        }
        return value;
    }

    public long readVarInt2(long max) throws IOException {
        long fb = Byte.toUnsignedLong(this.readByte());
        long value = fb == (long)ScriptOp.OP_PUSHDATA1.getByte() ? Byte.toUnsignedLong(this.readByte()) : (fb == (long)ScriptOp.OP_PUSHDATA2.getByte() ? Short.toUnsignedLong(this.readShort()) : (fb == (long)ScriptOp.OP_PUSHDATA4.getByte() ? Integer.toUnsignedLong(this.readInt()) : fb));
        if (Long.compareUnsigned(value, max) > 0) {
            throw new IOException(ErrorCode.ParamError);
        }
        return value;
    }

    public String readVarString() throws IOException {
        return new String(this.readVarBytes(), "UTF-8");
    }

    public int available() throws IOException {
        return this.reader.available();
    }

    public long Seek(long n) throws IOException {
        this.reader.reset();
        return this.reader.skip(n);
    }
}

