/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.merkle;

import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.common.UInt256;
import com.github.DNAProject.crypto.Digest;
import com.github.DNAProject.sdk.exception.SDKException;
import java.util.Arrays;

public class TreeHasher {
    public UInt256 hash_empty() {
        return new UInt256();
    }

    public UInt256 hash_leaf(byte[] data) {
        byte[] tmp = Helper.addBytes(new byte[]{0}, data);
        return new UInt256(Digest.sha256(tmp));
    }

    public UInt256 hash_children(UInt256 left, UInt256 right) {
        byte[] data = Helper.addBytes(new byte[]{1}, left.toArray());
        data = Helper.addBytes(data, right.toArray());
        return new UInt256(Digest.sha256(data));
    }

    public long countBit(long num) {
        long count = 0L;
        while (num != 0L) {
            num &= num - 1L;
            ++count;
        }
        return count;
    }

    public UInt256 HashFullTreeWithLeafHash(UInt256[] leaves) throws Exception {
        long length = leaves.length;
        Obj obj = this._hash_full(leaves, 0L, length);
        if ((long)obj.hashes.length != this.countBit(length)) {
            throw new SDKException(ErrorCode.AsserFailedHashFullTree);
        }
        return obj.root_hash;
    }

    public UInt256 HashFullTree(byte[][] leaves) throws Exception {
        int length = leaves.length;
        UInt256[] leafhashes = new UInt256[length];
        for (int i = 0; i < length; ++i) {
            leafhashes[i] = this.hash_leaf(leaves[i]);
        }
        Obj obj = this._hash_full(leafhashes, 0L, length);
        if ((long)obj.hashes.length != this.countBit(length)) {
            throw new Exception(ErrorCode.AsserFailedHashFullTree);
        }
        return obj.root_hash;
    }

    public Obj _hash_full(UInt256[] leaves, long l_idx, long r_idx) throws Exception {
        long width = r_idx - l_idx;
        if (width == 0L) {
            return new Obj(this.hash_empty(), null);
        }
        if (width == 1L) {
            UInt256 leaf_hash = leaves[(int)l_idx];
            return new Obj(leaf_hash, new UInt256[]{leaf_hash});
        }
        int split_width = 1 << (int)(this.countBit(width - 1L) - 1L);
        Obj lObj = this._hash_full(leaves, l_idx, l_idx + (long)split_width);
        if (lObj.hashes.length != 1) {
            throw new Exception(ErrorCode.LeftTreeFull);
        }
        Obj rObj = this._hash_full(leaves, l_idx + (long)split_width, r_idx);
        UInt256 root_hash = this.hash_children(lObj.root_hash, rObj.root_hash);
        UInt256[] hashes = null;
        if ((long)(split_width * 2) == width) {
            hashes = new UInt256[]{root_hash};
        } else {
            hashes = Arrays.copyOf(lObj.hashes, lObj.hashes.length + rObj.hashes.length);
            System.arraycopy(rObj.hashes, 0, hashes, lObj.hashes.length, rObj.hashes.length);
        }
        return new Obj(root_hash, hashes);
    }

    public UInt256 _hash_fold(UInt256[] hashes) {
        int l = hashes.length;
        UInt256 accum = hashes[l - 1];
        for (int i = l - 2; i >= 0; --i) {
            accum = this.hash_children(hashes[i], accum);
        }
        return accum;
    }

    class Obj {
        public UInt256 root_hash;
        public UInt256[] hashes;

        public Obj(UInt256 root_hash, UInt256[] hashes) {
            this.root_hash = root_hash;
            this.hashes = hashes;
        }
    }
}

