/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.network.rpc;

import com.alibaba.fastjson.JSON;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.network.exception.RpcException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Interfaces {
    private final URL url;

    public Interfaces(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    private static double getNextId() {
        double d = 0.0;
        do {
            d = Math.random();
        } while (("" + d).indexOf("E") != -1);
        return d;
    }

    public String getHost() {
        return this.url.getHost() + " " + this.url.getPort();
    }

    public Object call(String method, Object ... params) throws RpcException, IOException {
        Map req = this.makeRequest(method, params);
        Map response = (Map)this.send(req);
        if (response == null) {
            throw new RpcException(0, ErrorCode.ConnectUrlErr(this.url + "response is null. maybe is connect error"));
        }
        if ((Integer)response.get("error") == 0) {
            return response.get("result");
        }
        throw new RpcException(0, JSON.toJSONString((Object)response));
    }

    private Map makeRequest(String method, Object[] params) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("jsonrpc", "2.0");
        request.put("method", method);
        request.put("params", params);
        request.put("id", 1);
        System.out.println(String.format("POST url=%s,%s", this.url, JSON.toJSONString(request)));
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object send(Object request) throws IOException {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            try (OutputStreamWriter w = new OutputStreamWriter(connection.getOutputStream());){
                w.write(JSON.toJSONString((Object)request));
            }
            throwable = null;
            try (InputStreamReader r = new InputStreamReader(connection.getInputStream());){
                StringBuffer temp = new StringBuffer();
                int c = 0;
                while ((c = r.read()) != -1) {
                    temp.append((char)c);
                }
                Object object = JSON.parseObject((String)temp.toString(), Map.class);
                return object;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

