/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.network.rpc;

import com.github.DNAProject.common.Helper;
import com.github.DNAProject.common.UInt256;
import com.github.DNAProject.core.block.Block;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.io.Serializable;
import com.github.DNAProject.network.connect.AbstractConnector;
import com.github.DNAProject.network.exception.ConnectorException;
import com.github.DNAProject.network.exception.RpcException;
import com.github.DNAProject.network.rpc.Interfaces;
import java.io.IOException;
import java.net.MalformedURLException;

public class RpcClient
extends AbstractConnector {
    private Interfaces rpc;

    public RpcClient(String url) {
        try {
            this.rpc = new Interfaces(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getUrl() {
        return this.rpc.getHost();
    }

    @Override
    public Object getBalance(String address) throws ConnectorException, IOException {
        Object result = null;
        result = this.rpc.call("getbalance", address);
        return result;
    }

    @Override
    public String sendRawTransaction(String sData) throws RpcException, IOException {
        Object result = this.rpc.call("sendrawtransaction", sData);
        return (String)result;
    }

    @Override
    public Object sendRawTransaction(boolean preExec, String userid, String sData) throws RpcException, IOException {
        Object result = null;
        result = preExec ? this.rpc.call("sendrawtransaction", sData, 1) : this.rpc.call("sendrawtransaction", sData);
        return result;
    }

    @Override
    public Transaction getRawTransaction(String txhash) throws RpcException, IOException {
        Object result = this.rpc.call("getrawtransaction", txhash.toString());
        return Transaction.deserializeFrom(Helper.hexToBytes((String)result));
    }

    @Override
    public Object getRawTransactionJson(String txhash) throws RpcException, IOException {
        Object result = null;
        result = this.rpc.call("getrawtransaction", txhash.toString());
        return Transaction.deserializeFrom(Helper.hexToBytes((String)result)).json();
    }

    @Override
    public int getNodeCount() throws RpcException, IOException {
        Object result = this.rpc.call("getconnectioncount", new Object[0]);
        return (Integer)result;
    }

    @Override
    public int getBlockHeight() throws RpcException, IOException {
        Object result = this.rpc.call("getblockcount", new Object[0]);
        return (Integer)result - 1;
    }

    @Override
    public Object getBlockJson(int index) throws RpcException, IOException {
        Object result = null;
        result = this.rpc.call("getblock", index, 1);
        return result;
    }

    @Override
    public Object getBlockJson(String hash) throws RpcException, IOException {
        Object result = null;
        result = this.rpc.call("getblock", hash, 1);
        return result;
    }

    @Override
    public Object getContract(String hash) throws RpcException, IOException {
        Object result = null;
        result = this.rpc.call("getcontractstate", hash);
        return result;
    }

    @Override
    public Object getContractJson(String hash) throws RpcException, IOException {
        Object result = null;
        result = this.rpc.call("getcontractstate", hash, 1);
        return result;
    }

    public String getRawTransaction(UInt256 txhash) throws RpcException, IOException {
        Object result = this.rpc.call("getrawtransaction", txhash.toString());
        return (String)result;
    }

    public Block getBlock(UInt256 hash) throws RpcException, IOException {
        Object result = this.rpc.call("getblock", hash.toString());
        try {
            Block bb = Serializable.from(Helper.hexToBytes((String)result), Block.class);
            return bb;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Block getBlock(int index) throws RpcException, IOException {
        Object result = this.rpc.call("getblock", index);
        try {
            Block bb = Serializable.from(Helper.hexToBytes((String)result), Block.class);
            return bb;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getBlockCount() throws RpcException, IOException {
        Object result = this.rpc.call("getblockcount", new Object[0]);
        return (Integer)result;
    }

    @Override
    public Block getBlock(String hash) throws ConnectorException, IOException {
        Object result = this.rpc.call("getblock", hash.toString());
        try {
            Block bb = Serializable.from(Helper.hexToBytes((String)result), Block.class);
            return bb;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getSmartCodeEvent(int height) throws ConnectorException, IOException {
        Object result = this.rpc.call("getsmartcodeevent", height);
        try {
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getSmartCodeEvent(String hash) throws ConnectorException, IOException {
        Object result = this.rpc.call("getsmartcodeevent", hash.toString());
        try {
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getBlockHeightByTxHash(String hash) throws ConnectorException, IOException {
        Object result = this.rpc.call("getblockheightbytxhash", hash.toString());
        try {
            return (Integer)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStorage(String codehash, String key) throws ConnectorException, IOException {
        Object result = this.rpc.call("getstorage", codehash, key);
        try {
            return (String)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getMerkleProof(String hash) throws ConnectorException, IOException {
        Object result = this.rpc.call("getmerkleproof", hash);
        try {
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAllowance(String asset, String from, String to) throws ConnectorException, IOException {
        Object result = this.rpc.call("getallowance", asset, from, to);
        try {
            return (String)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getMemPoolTxCount() throws ConnectorException, IOException {
        Object result = this.rpc.call("getmempooltxcount", new Object[0]);
        try {
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getMemPoolTxState(String hash) throws ConnectorException, IOException {
        Object result = this.rpc.call("getmempooltxstate", hash);
        try {
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getVersion() throws ConnectorException, IOException {
        Object result = this.rpc.call("getversion", new Object[0]);
        try {
            return (String)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getGrantOng(String address) throws ConnectorException, IOException {
        Object result = this.rpc.call("getgrantong", address);
        try {
            return (String)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNetworkId() throws ConnectorException, IOException {
        Object result = this.rpc.call("getnetworkid", new Object[0]);
        try {
            return (Integer)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getNodeSyncStatus() throws ConnectorException, IOException {
        Object result = this.rpc.call("getsyncstatus", new Object[0]);
        try {
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSideChainData(String sideChainID) throws ConnectorException, IOException {
        Object result = this.rpc.call("getsidechaindata", sideChainID);
        try {
            return (String)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

