/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm;

import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.io.BinaryWriter;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.nativevm.abi.NativeBuildParams;
import com.github.DNAProject.smartcontract.nativevm.abi.Struct;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public class Auth {
    private DnaSdk sdk;
    private final String contractAddress = "0000000000000000000000000000000000000006";

    public Auth(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public String getContractAddress() {
        return "0000000000000000000000000000000000000006";
    }

    public String sendInit(String adminDnaId, String password, byte[] salt, String contractAddr, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (adminDnaId == null || adminDnaId.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BinaryWriter bw = new BinaryWriter(bos);
        bw.writeVarBytes(adminDnaId.getBytes());
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(contractAddr, "initContractAdmin", null, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, adminDnaId, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (!b) {
            throw new SDKException(ErrorCode.SendRawTxError);
        }
        return tx.hash().toHexString();
    }

    public String sendTransfer(String adminDnaId, String password, byte[] salt, long keyNo, String contractAddr, String newAdminDnaID, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (adminDnaId == null || adminDnaId.equals("") || contractAddr == null || contractAddr.equals("") || newAdminDnaID == null || newAdminDnaID.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("keyNo or gaslimit or gasprice should not be less than 0"));
        }
        Transaction tx = this.makeTransfer(adminDnaId, contractAddr, newAdminDnaID, keyNo, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, adminDnaId, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (!b) {
            throw new SDKException(ErrorCode.SendRawTxError);
        }
        return tx.hash().toHexString();
    }

    public Transaction makeTransfer(String adminDnaID, String contractAddr, String newAdminDnaID, long keyNo, String payer, long gaslimit, long gasprice) throws SDKException {
        if (adminDnaID == null || adminDnaID.equals("") || contractAddr == null || contractAddr.equals("") || newAdminDnaID == null || newAdminDnaID.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("keyNo or gaslimit or gasprice should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Helper.hexToBytes(contractAddr), newAdminDnaID.getBytes(), keyNo));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000006")), "transfer", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public String verifyToken(String dnaid, String password, byte[] salt, long keyNo, String contractAddr, String funcName) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || contractAddr == null || contractAddr.equals("") || funcName == null || funcName.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L) {
            throw new SDKException(ErrorCode.ParamErr("key or gaslimit or gas price should not be less than 0"));
        }
        Transaction tx = this.makeVerifyToken(dnaid, contractAddr, funcName, keyNo);
        this.sdk.signTx(tx, dnaid, password, salt);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        if (obj == null) {
            throw new SDKException(ErrorCode.OtherError("sendRawTransaction PreExec error: "));
        }
        return ((JSONObject)obj).getString("Result");
    }

    public Transaction makeVerifyToken(String dnaid, String contractAddr, String funcName, long keyNo) throws SDKException {
        if (dnaid == null || dnaid.equals("") || contractAddr == null || contractAddr.equals("") || funcName == null || funcName.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L) {
            throw new SDKException(ErrorCode.ParamErr("key or gaslimit or gas price should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Helper.hexToBytes(contractAddr), dnaid.getBytes(), funcName.getBytes(), keyNo));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000006")), "verifyToken", arg, null, 0L, 0L);
        return tx;
    }

    public String assignFuncsToRole(String adminDnaID, String password, byte[] salt, long keyNo, String contractAddr, String role, String[] funcName, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (adminDnaID == null || adminDnaID.equals("") || contractAddr == null || contractAddr.equals("") || role == null || role.equals("") || funcName == null || funcName.length == 0 || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("keyNo or gaslimit or gas price should not be less than 0"));
        }
        Transaction tx = this.makeAssignFuncsToRole(adminDnaID, contractAddr, role, funcName, keyNo, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, adminDnaID, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeAssignFuncsToRole(String adminDnaID, String contractAddr, String role, String[] funcName, long keyNo, String payer, long gaslimit, long gasprice) throws SDKException {
        if (adminDnaID == null || adminDnaID.equals("") || contractAddr == null || contractAddr.equals("") || role == null || role.equals("") || funcName == null || funcName.length == 0 || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("keyNo or gaslimit or gas price should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(Helper.hexToBytes(contractAddr), adminDnaID.getBytes(), role.getBytes());
        struct.add(funcName.length);
        for (int i = 0; i < funcName.length; ++i) {
            struct.add(funcName[i]);
        }
        struct.add(keyNo);
        list.add(struct);
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000006")), "assignFuncsToRole", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public String assignDnaIdsToRole(String adminDnaId, String password, byte[] salt, long keyNo, String contractAddr, String role, String[] dnaIDs, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (adminDnaId == null || adminDnaId.equals("") || password == null || password.equals("") || contractAddr == null || contractAddr.equals("") || role == null || role.equals("") || dnaIDs == null || dnaIDs.length == 0) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("keyNo or gaslimit or gasprice should not be less than 0"));
        }
        Transaction tx = this.makeAssignDnaIDsToRole(adminDnaId, contractAddr, role, dnaIDs, keyNo, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, adminDnaId, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeAssignDnaIDsToRole(String adminDnaId, String contractAddr, String role, String[] dnaIDs, long keyNo, String payer, long gaslimit, long gasprice) throws SDKException {
        if (adminDnaId == null || adminDnaId.equals("") || contractAddr == null || contractAddr.equals("") || role == null || role.equals("") || dnaIDs == null || dnaIDs.length == 0) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("keyNo or gaslimit or gasprice should not be less than 0"));
        }
        byte[][] dnaId = new byte[dnaIDs.length][];
        for (int i = 0; i < dnaIDs.length; ++i) {
            dnaId[i] = dnaIDs[i].getBytes();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Struct struct = new Struct();
        struct.add(Helper.hexToBytes(contractAddr), adminDnaId.getBytes(), role.getBytes());
        struct.add(dnaId.length);
        for (int i = 0; i < dnaId.length; ++i) {
            struct.add(new Object[]{dnaId[i]});
        }
        struct.add(keyNo);
        list.add(struct);
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000006")), "assignOntIDsToRole", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public String delegate(String dnaid, String password, byte[] salt, long keyNo, String contractAddr, String toDnaId, String role, long period, long level, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (dnaid == null || dnaid.equals("") || password == null || password.equals("") || contractAddr == null || contractAddr.equals("") || toDnaId == null || toDnaId.equals("") || role == null || role.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (period < 0L || level < 0L || keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("period level key gaslimit or gasprice should not be less than 0"));
        }
        Transaction tx = this.makeDelegate(dnaid, contractAddr, toDnaId, role, period, level, keyNo, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, dnaid, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeDelegate(String dnaid, String contractAddr, String toAddr, String role, long period, long level, long keyNo, String payer, long gaslimit, long gasprice) throws SDKException {
        if (dnaid == null || dnaid.equals("") || contractAddr == null || contractAddr.equals("") || toAddr == null || toAddr.equals("") || role == null || role.equals("") || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (period < 0L || level < 0L || keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("period level keyNo gaslimit or gasprice should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Helper.hexToBytes(contractAddr), dnaid.getBytes(), toAddr.getBytes(), role.getBytes(), period, level, keyNo));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000006")), "delegate", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public String withdraw(String initiatorDnaid, String password, byte[] salt, long keyNo, String contractAddr, String delegate, String role, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (initiatorDnaid == null || initiatorDnaid.equals("") || password == null || password.equals("") || contractAddr == null || contractAddr.equals("") || role == null || role.equals("") || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("keyNo or gaslimit or gasprice should not be less than 0"));
        }
        Transaction tx = this.makeWithDraw(initiatorDnaid, contractAddr, delegate, role, keyNo, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, initiatorDnaid, password, salt);
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeWithDraw(String dnaid, String contractAddr, String delegate, String role, long keyNo, String payer, long gaslimit, long gasprice) throws SDKException {
        if (dnaid == null || dnaid.equals("") || contractAddr == null || contractAddr.equals("") || role == null || role.equals("") || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        if (keyNo < 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("key gaslimit or gasprice should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Helper.hexToBytes(contractAddr), dnaid.getBytes(), delegate.getBytes(), role.getBytes(), keyNo));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000006")), "withdraw", arg, payer, gaslimit, gasprice);
        return tx;
    }

    public Object queryAuth(String contractAddr, String role, String dnaid) throws Exception {
        String obj = this.sdk.getConnect().getStorage(contractAddr, contractAddr + Helper.toHexString(role.getBytes()) + Helper.toHexString(dnaid.getBytes()));
        return obj;
    }
}

