/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.nativevm;

import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.asset.State;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.nativevm.abi.NativeBuildParams;
import com.github.DNAProject.smartcontract.nativevm.abi.Struct;
import java.util.ArrayList;

public class Gas {
    private DnaSdk sdk;
    private final String contract = "0000000000000000000000000000000000000001";
    private final String gasContract = "0000000000000000000000000000000000000002";

    public Gas(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public String getContractAddress() {
        return "0000000000000000000000000000000000000002";
    }

    public String sendTransfer(Account sendAcct, String recvAddr, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (sendAcct == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (amount <= 0L || gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        Transaction tx = this.makeTransfer(sendAcct.getAddressU160().toBase58(), recvAddr, amount, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{sendAcct}});
        if (!sendAcct.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendTransferMulti(Account[] accounts, State[] states, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (accounts == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        Transaction tx = this.makeTransfer(states, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{payerAcct}});
        for (int i = 0; i < accounts.length; ++i) {
            if (accounts[i].equals(payerAcct)) continue;
            this.sdk.addSign(tx, accounts[i]);
        }
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public String sendTransferFromMultiSignAddr(int M, byte[][] pubKeys, Account[] sendAccts, String recvAddr, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        if (sendAccts == null || sendAccts.length <= 1 || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (amount <= 0L || gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        Address multiAddr = Address.addressFromMultiPubKeys(sendAccts.length, pubKeys);
        Transaction tx = this.makeTransfer(multiAddr.toBase58(), recvAddr, amount, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        for (int i = 0; i < sendAccts.length; ++i) {
            this.sdk.addMultiSign(tx, M, pubKeys, sendAccts[i]);
        }
        this.sdk.addSign(tx, payerAcct);
        boolean b = this.sdk.getConnect().sendRawTransaction(tx.toHexString());
        if (b) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeTransfer(String sendAddr, String recvAddr, long amount, String payer, long gaslimit, long gasprice) throws Exception {
        if (sendAddr == null || sendAddr.equals("") || recvAddr == null || recvAddr.equals("") || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (amount <= 0L || gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<Struct> listStruct = new ArrayList<Struct>();
        listStruct.add(new Struct().add(Address.decodeBase58(sendAddr), Address.decodeBase58(recvAddr), amount));
        list.add(listStruct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "transfer", args, payer, gaslimit, gasprice);
        return tx;
    }

    public Transaction makeTransfer(State[] states, String payer, long gaslimit, long gasprice) throws Exception {
        if (states == null || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamError);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<Struct> listStruct = new ArrayList<Struct>();
        for (int i = 0; i < states.length; ++i) {
            listStruct.add(new Struct().add(states[i].from, states[i].to, states[i].value));
        }
        list.add(listStruct);
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "transfer", args, payer, gaslimit, gasprice);
        return tx;
    }

    public long queryBalanceOf(String address) throws Exception {
        if (address == null || address.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("address should not be null"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Address.decodeBase58(address));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "balanceOf", arg, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if (res == null || res.equals("")) {
            return 0L;
        }
        return Long.valueOf(Helper.reverse(res), 16);
    }

    public long queryAllowance(String fromAddr, String toAddr) throws Exception {
        if (fromAddr == null || fromAddr.equals("") || toAddr == null || toAddr.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameter should not be null"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Address.decodeBase58(fromAddr), Address.decodeBase58(toAddr)));
        byte[] arg = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "allowance", arg, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if (res == null || res.equals("")) {
            return 0L;
        }
        return Long.valueOf(Helper.reverse(res), 16);
    }

    public String sendApprove(Account sendAcct, String recvAddr, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (sendAcct == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (amount <= 0L || gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        Transaction tx = this.makeApprove(sendAcct.getAddressU160().toBase58(), recvAddr, amount, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{sendAcct}});
        if (!sendAcct.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeApprove(String sendAddr, String recvAddr, long amount, String payer, long gaslimit, long gasprice) throws Exception {
        if (sendAddr == null || sendAddr.equals("") || recvAddr == null || recvAddr.equals("") || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (amount <= 0L || gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Address.decodeBase58(sendAddr), Address.decodeBase58(recvAddr), amount));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "approve", args, payer, gaslimit, gasprice);
        return tx;
    }

    public String sendTransferFrom(Account sendAcct, String fromAddr, String toAddr, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (sendAcct == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (amount <= 0L || gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        Transaction tx = this.makeTransferFrom(sendAcct.getAddressU160().toBase58(), fromAddr, toAddr, amount, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{sendAcct}});
        if (!sendAcct.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toHexString();
        }
        return null;
    }

    public Transaction makeTransferFrom(String sendAddr, String fromAddr, String toAddr, long amount, String payer, long gaslimit, long gasprice) throws Exception {
        if (sendAddr == null || sendAddr.equals("") || fromAddr == null || fromAddr.equals("") || toAddr == null || toAddr.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("parameters should not be null"));
        }
        if (amount <= 0L || gasprice < 0L || gaslimit < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gasprice or gaslimit should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Address.decodeBase58(sendAddr), Address.decodeBase58(fromAddr), Address.decodeBase58(toAddr), amount));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "transferFrom", args, payer, gaslimit, gasprice);
        return tx;
    }

    public String queryName() throws Exception {
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "name", new byte[]{0}, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        return new String(Helper.hexToBytes(res));
    }

    public String querySymbol() throws Exception {
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "symbol", new byte[]{0}, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        return new String(Helper.hexToBytes(res));
    }

    public long queryDecimals() throws Exception {
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "decimals", new byte[]{0}, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if ("".equals(res)) {
            return 0L;
        }
        return Long.valueOf(Helper.reverse(res), 16);
    }

    public long queryTotalSupply() throws Exception {
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "totalSupply", new byte[]{0}, null, 0L, 0L);
        Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
        String res = ((JSONObject)obj).getString("Result");
        if (res == null || res.equals("")) {
            return 0L;
        }
        return Long.valueOf(Helper.reverse(res), 16);
    }

    public String unboundGas(String address) throws Exception {
        if (address == null || address.equals("")) {
            throw new SDKException(ErrorCode.ParamErr("address should not be null"));
        }
        String unboundGasStr = this.sdk.getConnect().getAllowance("gas", Address.parse("0000000000000000000000000000000000000001").toBase58(), address);
        long unboundGas = Long.parseLong(unboundGasStr);
        return unboundGasStr;
    }

    public String withdrawGas(Account sendAcct, String toAddr, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        boolean b;
        if (sendAcct == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamError);
        }
        if (amount <= 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gaslimit gasprice should not be less than 0"));
        }
        Transaction tx = this.makeWithdrawGas(sendAcct.getAddressU160().toBase58(), toAddr, amount, payerAcct.getAddressU160().toBase58(), gaslimit, gasprice);
        this.sdk.signTx(tx, new Account[][]{{sendAcct}});
        if (!sendAcct.equals(payerAcct)) {
            this.sdk.addSign(tx, payerAcct);
        }
        if (b = this.sdk.getConnect().sendRawTransaction(tx.toHexString())) {
            return tx.hash().toString();
        }
        return null;
    }

    public Transaction makeWithdrawGas(String claimer, String toAddr, long amount, String payer, long gaslimit, long gasprice) throws Exception {
        if (claimer == null || claimer.equals("") || toAddr == null || toAddr.equals("") || payer == null || payer.equals("")) {
            throw new SDKException(ErrorCode.ParamError);
        }
        if (amount <= 0L || gaslimit < 0L || gasprice < 0L) {
            throw new SDKException(ErrorCode.ParamErr("amount or gaslimit gasprice should not be less than 0"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Struct().add(Address.decodeBase58(claimer), Address.parse("0000000000000000000000000000000000000001"), Address.decodeBase58(toAddr), amount));
        byte[] args = NativeBuildParams.createCodeParamsScript(list);
        Transaction tx = this.sdk.vm().buildNativeParams(new Address(Helper.hexToBytes("0000000000000000000000000000000000000002")), "transferFrom", args, payer, gaslimit, gasprice);
        return tx;
    }
}

