/*
 * Decompiled with CFR 0.152.
 */
package com.github.DNAProject.smartcontract.neovm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.ErrorCode;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.core.payload.InvokeCode;
import com.github.DNAProject.core.transaction.Transaction;
import com.github.DNAProject.sdk.exception.SDKException;
import com.github.DNAProject.smartcontract.neovm.abi.AbiFunction;
import com.github.DNAProject.smartcontract.neovm.abi.AbiInfo;
import com.github.DNAProject.smartcontract.neovm.abi.BuildParams;
import java.math.BigInteger;

public class Nep5 {
    private DnaSdk sdk;
    private String contractAddress = null;
    private String nep5abi = "{\"hash\":\"0xd17d91a831c094c1fd8d8634b8cd6fa9fbaedc99\",\"entrypoint\":\"Main\",\"functions\":[{\"name\":\"Name\",\"parameters\":[],\"returntype\":\"String\"},{\"name\":\"Symbol\",\"parameters\":[],\"returntype\":\"String\"},{\"name\":\"Decimals\",\"parameters\":[],\"returntype\":\"Integer\"},{\"name\":\"Main\",\"parameters\":[{\"name\":\"operation\",\"type\":\"String\"},{\"name\":\"args\",\"type\":\"Array\"}],\"returntype\":\"Any\"},{\"name\":\"Init\",\"parameters\":[],\"returntype\":\"Boolean\"},{\"name\":\"TotalSupply\",\"parameters\":[],\"returntype\":\"Integer\"},{\"name\":\"Transfer\",\"parameters\":[{\"name\":\"from\",\"type\":\"ByteArray\"},{\"name\":\"to\",\"type\":\"ByteArray\"},{\"name\":\"value\",\"type\":\"Integer\"}],\"returntype\":\"Boolean\"},{\"name\":\"BalanceOf\",\"parameters\":[{\"name\":\"address\",\"type\":\"ByteArray\"}],\"returntype\":\"Integer\"}],\"events\":[{\"name\":\"transfer\",\"parameters\":[{\"name\":\"arg1\",\"type\":\"ByteArray\"},{\"name\":\"arg2\",\"type\":\"ByteArray\"},{\"name\":\"arg3\",\"type\":\"Integer\"}],\"returntype\":\"Void\"}]}";

    public Nep5(DnaSdk sdk) {
        this.sdk = sdk;
    }

    public void setContractAddress(String codeHash) {
        this.contractAddress = codeHash.replace("0x", "");
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String sendInit(Account acct, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return (String)this.sendInit(acct, payerAcct, gaslimit, gasprice, false);
    }

    public long sendInitPreExec(Account acct, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return (Long)this.sendInit(acct, payerAcct, gaslimit, gasprice, true);
    }

    private Object sendInit(Account acct, Account payerAcct, long gaslimit, long gasprice, boolean preExec) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("Init");
        func.name = "init";
        if (preExec) {
            Object obj;
            byte[] params = BuildParams.serializeAbiFunction(func);
            InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(this.getContractAddress(), null, params, null, 0L, 0L);
            if (acct != null) {
                this.sdk.signTx(tx, new Account[][]{{acct}});
            }
            if (Integer.parseInt(((JSONObject)(obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString()))).getString("Result")) != 1) {
                throw new SDKException(ErrorCode.OtherError("sendRawTransaction PreExec error: " + obj));
            }
            return ((JSONObject)obj).getLong("Gas");
        }
        if (acct == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamError);
        }
        Object obj = this.sdk.neovm().sendTransaction(this.contractAddress, acct, payerAcct, gaslimit, gasprice, func, preExec);
        return obj;
    }

    public String sendTransfer(Account acct, String recvAddr, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        return (String)this.sendTransfer(acct, recvAddr, amount, payerAcct, gaslimit, gasprice, false);
    }

    public long sendTransferPreExec(Account acct, String recvAddr, long amount) throws Exception {
        return (Long)this.sendTransfer(acct, recvAddr, amount, acct, 0L, 0L, true);
    }

    private Object sendTransfer(Account acct, String recvAddr, long amount, Account payerAcct, long gaslimit, long gasprice, boolean preExec) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        if (acct == null || payerAcct == null) {
            throw new SDKException(ErrorCode.ParamError);
        }
        String sendAddr = acct.getAddressU160().toBase58();
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("Transfer");
        func.name = "transfer";
        func.setParamsValue(Address.decodeBase58(sendAddr).toArray(), Address.decodeBase58(recvAddr).toArray(), amount);
        if (preExec) {
            byte[] params = BuildParams.serializeAbiFunction(func);
            InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(this.getContractAddress(), null, params, null, 0L, 0L);
            this.sdk.signTx(tx, new Account[][]{{acct}});
            Object obj = this.sdk.getConnect().sendRawTransactionPreExec(tx.toHexString());
            if (Integer.parseInt(((JSONObject)obj).getString("Result")) != 1) {
                throw new SDKException(ErrorCode.OtherError("sendRawTransaction PreExec error: " + obj));
            }
            return ((JSONObject)obj).getLong("Gas");
        }
        Object obj = this.sdk.neovm().sendTransaction(this.contractAddress, acct, payerAcct, gaslimit, gasprice, func, preExec);
        return obj;
    }

    public Transaction makeTransfer(String sendAddr, String recvAddr, long amount, Account payerAcct, long gaslimit, long gasprice) throws Exception {
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("Transfer");
        func.name = "transfer";
        func.setParamsValue(Address.decodeBase58(sendAddr).toArray(), Address.decodeBase58(recvAddr).toArray(), amount);
        byte[] params = BuildParams.serializeAbiFunction(func);
        String payer = payerAcct.getAddressU160().toBase58();
        InvokeCode tx = this.sdk.vm().makeInvokeCodeTransaction(this.getContractAddress(), null, params, payer, gaslimit, gasprice);
        return tx;
    }

    public String queryBalanceOf(String addr) throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("BalanceOf");
        func.name = "balanceOf";
        func.setParamsValue(new Object[]{Address.decodeBase58(addr).toArray()});
        Object obj = this.sdk.neovm().sendTransaction(this.contractAddress, null, null, 0L, 0L, func, true);
        String balance = ((JSONObject)obj).getString("Result");
        if (balance == null || balance.equals("")) {
            return BigInteger.ZERO.toString();
        }
        return Helper.BigIntFromNeoBytes(Helper.hexToBytes(balance)).toString();
    }

    public String queryTotalSupply() throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("TotalSupply");
        func.name = "totalSupply";
        func.setParamsValue(new Object[0]);
        Object obj = this.sdk.neovm().sendTransaction(this.contractAddress, null, null, 0L, 0L, func, true);
        String total = ((JSONObject)obj).getString("Result");
        return Helper.BigIntFromNeoBytes(Helper.hexToBytes(total)).toString();
    }

    public String queryName() throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("Name");
        func.name = "name";
        func.setParamsValue(new Object[0]);
        Object obj = this.sdk.neovm().sendTransaction(this.contractAddress, null, null, 0L, 0L, func, true);
        return new String(Helper.hexToBytes(((JSONObject)obj).getString("Result")));
    }

    public String queryDecimals() throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("Decimals");
        func.name = "decimals";
        func.setParamsValue(new Object[0]);
        Object obj = this.sdk.neovm().sendTransaction(this.contractAddress, null, null, 0L, 0L, func, true);
        String decimal = ((JSONObject)obj).getString("Result");
        return Helper.BigIntFromNeoBytes(Helper.hexToBytes(decimal)).toString();
    }

    public String querySymbol() throws Exception {
        if (this.contractAddress == null) {
            throw new SDKException(ErrorCode.NullCodeHash);
        }
        AbiInfo abiinfo = (AbiInfo)JSON.parseObject((String)this.nep5abi, AbiInfo.class);
        AbiFunction func = abiinfo.getFunction("Symbol");
        func.name = "symbol";
        func.setParamsValue(new Object[0]);
        Object obj = this.sdk.neovm().sendTransaction(this.contractAddress, null, null, 0L, 0L, func, true);
        return new String(Helper.hexToBytes(((JSONObject)obj).getString("Result")));
    }
}

