/*
 * Decompiled with CFR 0.152.
 */
package example.dnaid;

import com.alibaba.fastjson.JSONObject;
import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Common;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.crypto.SignatureScheme;
import com.github.DNAProject.sdk.info.AccountInfo;
import com.github.DNAProject.sdk.wallet.Identity;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;

public class ClaimRecordTxDemo {
    public static void main(String[] args) {
        try {
            DnaSdk dnaSdk = ClaimRecordTxDemo.getDnaSdk();
            String password = "111111";
            com.github.DNAProject.sdk.wallet.Account payerAccInfo = dnaSdk.getWalletMgr().createAccount(password);
            Account payerAcc = dnaSdk.getWalletMgr().getAccount(payerAccInfo.address, password, payerAccInfo.getSalt());
            if (dnaSdk.getWalletMgr().getWallet().getIdentities().size() < 2) {
                Identity identity = dnaSdk.getWalletMgr().createIdentity(password);
                dnaSdk.nativevm().dnaId().sendRegister(identity, password, payerAcc, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
                Identity identity2 = dnaSdk.getWalletMgr().createIdentity(password);
                dnaSdk.nativevm().dnaId().sendRegister(identity2, password, payerAcc, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
                dnaSdk.getWalletMgr().writeWallet();
                Thread.sleep(6000L);
            }
            List<Identity> dids = dnaSdk.getWalletMgr().getWallet().getIdentities();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Issuer", dids.get((int)0).dnaid);
            map.put("Subject", dids.get((int)1).dnaid);
            HashMap<String, String> clmRevMap = new HashMap<String, String>();
            clmRevMap.put("typ", "AttestContract");
            clmRevMap.put("addr", dids.get((int)1).dnaid.replace(Common.diddna, ""));
            String claim = dnaSdk.nativevm().dnaId().createDnaIdClaim(dids.get((int)0).dnaid, password, dids.get((int)0).controls.get(0).getSalt(), "claim:context", map, map, clmRevMap, System.currentTimeMillis() / 1000L + 100000L);
            System.out.println(claim);
            boolean b = dnaSdk.nativevm().dnaId().verifyDnaIdClaim(claim);
            System.out.println(b);
            com.github.DNAProject.sdk.wallet.Account account = dnaSdk.getWalletMgr().importAccount("blDuHRtsfOGo9A79rxnJFo2iOMckxdFDfYe2n6a9X+jdMCRkNUfs4+C4vgOfCOQ5", "111111", "AazEvfQPcQ2GEFFPLF1ZLwQ7K5jDn81hve", Base64.getDecoder().decode("0hAaO6CT+peDil9s5eoHyw=="));
            AccountInfo info = dnaSdk.getWalletMgr().getAccountInfo(account.address, "111111", account.getSalt());
            Account account1 = new Account(Helper.hexToBytes("75de8489fcb2dcaf2ef3cd607feffde18789de7da129b5e97c81e001793cb7cf"), SignatureScheme.SHA256WITHECDSA);
            String[] claims = claim.split("\\.");
            JSONObject payload = JSONObject.parseObject((String)new String(Base64.getDecoder().decode(claims[1].getBytes())));
            System.out.println("ClaimId:" + payload.getString("jti"));
            String commitHash = dnaSdk.neovm().claimRecord().sendCommit(dids.get((int)0).dnaid, password, dids.get((int)0).controls.get(0).getSalt(), dids.get((int)1).dnaid, payload.getString("jti"), account1, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
            System.out.println("commitRes:" + commitHash);
            Thread.sleep(6000L);
            Object obj = dnaSdk.getConnect().getSmartCodeEvent(commitHash);
            System.out.println(obj);
            System.out.println(Helper.toHexString(dids.get((int)0).dnaid.getBytes()));
            System.out.println(Helper.toHexString(dids.get((int)1).dnaid.getBytes()));
            System.out.println(Helper.toHexString(payload.getString("jti").getBytes()));
            System.out.println(payload.getString("jti"));
            String getstatusRes = dnaSdk.neovm().claimRecord().sendGetStatus(payload.getString("jti"));
            System.out.println("getstatusResBytes:" + getstatusRes);
            Thread.sleep(6000L);
            String revokeHash = dnaSdk.neovm().claimRecord().sendRevoke(dids.get((int)0).dnaid, password, dids.get((int)0).controls.get(0).getSalt(), payload.getString("jti"), account1, dnaSdk.DEFAULT_GAS_LIMIT, 0L);
            System.out.println("revokeRes:" + revokeHash);
            Thread.sleep(6000L);
            System.out.println(dnaSdk.getConnect().getSmartCodeEvent(revokeHash));
            String getstatusRes2 = dnaSdk.neovm().claimRecord().sendGetStatus(payload.getString("jti"));
            System.out.println("getstatusResBytes2:" + getstatusRes2);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("ClaimRecordTxDemo.json");
        return wm;
    }
}

