/*
 * Decompiled with CFR 0.152.
 */
package example.oep;

import com.github.DNAProject.DnaSdk;
import com.github.DNAProject.account.Account;
import com.github.DNAProject.common.Address;
import com.github.DNAProject.common.Helper;
import com.github.DNAProject.smartcontract.neovm.oep5.Oep5Param;

public class Oep5Demo {
    public static void main(String[] args) {
        try {
            DnaSdk sdk = Oep5Demo.getDnaSdk();
            Account account = sdk.getWalletMgr().getAccount("AQf4Mzu1YJrhz9f3aRkkwSm9n3qhXGSh4p", "xinhao");
            Account account1 = sdk.getWalletMgr().getAccount("ARR5ywDEx3ybXkMGmZPFYu9hiC8J4xvNdc", "xinhao");
            Account account2 = sdk.getWalletMgr().getAccount("AacHGsQVbTtbvSWkqZfvdKePLS6K659dgp", "xinhao");
            String tokenId1 = sdk.neovm().oep5().queryTokenIDByIndex(1);
            String res0 = sdk.neovm().oep5().ownerOf(Helper.hexToBytes(tokenId1));
            System.out.println("owner1: " + new Address(Helper.hexToBytes(res0)).toBase58());
            Oep5Param param = new Oep5Param(account1.getAddressU160().toArray(), Helper.hexToBytes(tokenId1));
            String res = sdk.neovm().oep5().takeOwnership(account1, param, account1, 20000L, 0L);
            System.out.println("res: " + res);
            Thread.sleep(6000L);
            System.out.println(sdk.getConnect().getSmartCodeEvent(res));
            String res1 = sdk.neovm().oep5().ownerOf(Helper.hexToBytes(tokenId1));
            System.out.println("owner1: " + new Address(Helper.hexToBytes(res1)).toBase58());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static DnaSdk getDnaSdk() throws Exception {
        String ip = "http://127.0.0.1";
        String restUrl = ip + ":20334";
        String rpcUrl = ip + ":20336";
        String wsUrl = ip + ":20335";
        DnaSdk wm = DnaSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.neovm().oep5().setContractAddress("6d16074febe9a2db0099570916bcb412787265ea");
        wm.openWalletFile("oep5.dat");
        return wm;
    }
}

