package api4s.codegen

import java.io.PrintWriter

import api4s.codegen.ast.Stages
import api4s.codegen.emitter.{ CirceModel, ClientServerApi, Http4sClient, Http4sServer }
import api4s.codegen.swagger.Root

object Main extends App {
  val src = scala.io.Source
    //.fromURL("https://netstorage.ringcentral.com/dpw/api-reference/specs/rc-platform.yml?v=2019080420190715-0339")
    .fromURL("https://raw.githubusercontent.com/APIs-guru/openapi-directory/master/APIs/googleapis.com/analytics/v3/swagger.yaml")
    //.fromFile("/tmp/petstore.yaml")
  val api = Stages(Root(src.mkString).api)
  val pref = "core/src/test/scala/test"
  new PrintWriter(s"$pref/Model.scala") {
    write(CirceModel("test", api.types))
    close()
  }
  new PrintWriter(s"$pref/Api.scala") {
    write(ClientServerApi("test", api.endpoints))
    close()
  }
  new PrintWriter(s"$pref/Http4sClient.scala") {
    write(Http4sClient("test", api.endpoints))
    close()
  }
  new PrintWriter(s"$pref/Http4sServer.scala") {
    write(Http4sServer("test", api.endpoints))
    close()
  }
  src.close()
}
