/*
 * Decompiled with CFR 0.152.
 */
package com.github.advisedtesting.core.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

public class AdviceAnnotationEvaluator {
    private static boolean hasAdviceClass(Annotation annotation) {
        Class value = AdviceAnnotationEvaluator.getValueIfPresent(annotation, "implementedBy", Class.class);
        try {
            return value != null && MethodInterceptor.class.isAssignableFrom(value) && value.getConstructor(new Class[0]) != null;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return false;
        }
    }

    public static List<Annotation> inspect(Annotation ... annotations) {
        ArrayList<Annotation> output = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (AdviceAnnotationEvaluator.hasAdviceClass(annotation)) {
                output.add(annotation);
                continue;
            }
            for (Method method : annotation.annotationType().getMethods()) {
                method.setAccessible(true);
                if (Annotation.class.isAssignableFrom(method.getReturnType())) {
                    try {
                        output.addAll(AdviceAnnotationEvaluator.inspect((Annotation)method.invoke((Object)annotation, (Object[])null)));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
                if (method.getReturnType().getComponentType() == null || !Annotation.class.isAssignableFrom(method.getReturnType().getComponentType())) continue;
                try {
                    output.addAll(AdviceAnnotationEvaluator.inspect((Annotation[])method.invoke((Object)annotation, (Object[])null)));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return output;
    }

    public static String getInstanceIfPresent(Annotation annotation) {
        String value = AdviceAnnotationEvaluator.getValueIfPresent(annotation, "instance", String.class);
        if (!"__default".equals(value)) {
            return value;
        }
        return null;
    }

    public static String getNameIfPresent(Annotation annotation) {
        String value = AdviceAnnotationEvaluator.getValueIfPresent(annotation, "name", String.class);
        if (!"__default".equals(value)) {
            return value;
        }
        return null;
    }

    public static <T> T getValueIfPresent(Annotation annotation, String name, Class<T> output) {
        if (annotation == null) {
            return null;
        }
        for (Method method : annotation.annotationType().getMethods()) {
            String methodName = method.getName();
            if (!name.equals(methodName) || !output.isAssignableFrom(method.getReturnType())) continue;
            try {
                method.setAccessible(true);
                return (T)method.invoke((Object)annotation, (Object[])null);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

