/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.api.requests;

import com.github.angleshq.angles.api.exceptions.AnglesServerException;
import com.github.angleshq.angles.api.models.Environment;
import com.github.angleshq.angles.api.requests.BaseRequests;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;

public class EnvironmentRequests
extends BaseRequests {
    private String basePath = "environment";

    public EnvironmentRequests(String baseUrl) {
        super(baseUrl);
    }

    public Environment create(Environment environment) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPost(this.basePath, environment);
        return this.processResponse(response, Environment.class);
    }

    public Environment[] get() throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath);
        return this.processResponse(response, Environment[].class);
    }

    public Environment get(String environmentId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath + "/" + environmentId);
        return this.processResponse(response, Environment.class);
    }

    public Boolean delete(String environmentId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendDelete(this.basePath + "/" + environmentId);
        if (response.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        this.processErrorResponse(response);
        return false;
    }

    public Environment update(Environment environment) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + environment.getId(), environment);
        return this.processResponse(response, Environment.class);
    }
}

