/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.api.requests;

import com.github.angleshq.angles.api.exceptions.AnglesServerException;
import com.github.angleshq.angles.api.models.Platform;
import com.github.angleshq.angles.api.models.screenshot.CreateScreenshot;
import com.github.angleshq.angles.api.models.screenshot.ImageCompareResponse;
import com.github.angleshq.angles.api.models.screenshot.Screenshot;
import com.github.angleshq.angles.api.models.screenshot.UpdateScreenshot;
import com.github.angleshq.angles.api.requests.BaseRequests;
import com.google.gson.JsonArray;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.tika.Tika;

public class ScreenshotRequests
extends BaseRequests {
    private String basePath = "screenshot";
    private Tika tika = new Tika();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public ScreenshotRequests(String baseUrl) {
        super(baseUrl);
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public Screenshot create(CreateScreenshot createScreenshot) throws IOException, AnglesServerException {
        File screenShotFile = new File(createScreenshot.getFilePath());
        String mimeType = this.tika.detect(screenShotFile);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addBinaryBody("screenshot", screenShotFile, ContentType.getByMimeType((String)mimeType), screenShotFile.getName()).addTextBody("view", createScreenshot.getView()).addTextBody("buildId", createScreenshot.getBuildId()).addTextBody("timestamp", this.sdf.format(createScreenshot.getTimestamp())).setContentType(ContentType.MULTIPART_FORM_DATA);
        if (createScreenshot.getPlatform() != null) {
            Platform platform = createScreenshot.getPlatform();
            if (platform.getPlatformName() != null) {
                entityBuilder.addTextBody("platformName", platform.getPlatformName());
            }
            if (platform.getPlatformVersion() != null) {
                entityBuilder.addTextBody("platformVersion", platform.getPlatformVersion());
            }
            if (platform.getBrowserName() != null) {
                entityBuilder.addTextBody("browserName", platform.getBrowserName());
            }
            if (platform.getBrowserVersion() != null) {
                entityBuilder.addTextBody("browserVersion", platform.getBrowserVersion());
            }
            if (platform.getDeviceName() != null) {
                entityBuilder.addTextBody("deviceName", platform.getDeviceName());
            }
        }
        if (createScreenshot.getTags() != null) {
            JsonArray jsonArray = new JsonArray();
            for (String tag : createScreenshot.getTags()) {
                jsonArray.add(tag);
            }
            entityBuilder.addTextBody("tags", jsonArray.toString());
        }
        HttpEntity entity = entityBuilder.build();
        CloseableHttpResponse response = this.sendMultiPartEntity(this.basePath, new HashMap<String, String>(), entity);
        return this.processResponse(response, Screenshot.class);
    }

    public Screenshot[] get(String buildId, String view, Integer limit, Integer skip) throws IOException, URISyntaxException, AnglesServerException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (buildId != null) {
            parameters.put("buildId", view);
        }
        if (view != null) {
            parameters.put("view", view);
        }
        if (limit != null) {
            parameters.put("limit", limit);
        }
        if (skip != null) {
            parameters.put("skip", skip);
        }
        CloseableHttpResponse response = this.sendJSONGet(this.basePath, parameters);
        return this.processResponse(response, Screenshot[].class);
    }

    public Screenshot get(String screenshotId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath + "/" + screenshotId);
        return this.processResponse(response, Screenshot.class);
    }

    public ImageCompareResponse baselineCompare(String screenshotId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath + "/" + screenshotId + "/baseline/compare");
        return this.processResponse(response, ImageCompareResponse.class);
    }

    public Boolean delete(String screenshotId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendDelete(this.basePath + "/" + screenshotId);
        if (response.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        this.processErrorResponse(response);
        return false;
    }

    public Screenshot update(String screenshotId, UpdateScreenshot updateRequest) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + screenshotId, updateRequest);
        return this.processResponse(response, Screenshot.class);
    }
}

