/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import sk.antons.jaul.Replace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitiveProperties {
    public static void makeClosure(Properties props) {
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String property = (String)entry.getKey();
            String value = (String)entry.getValue();
            String newvalue = TransitiveProperties.makeClosureForProperty(props, property, new ArrayList<String>());
            props.put(property, newvalue);
        }
    }

    public static Properties wrap(Properties props) {
        if (props == null) {
            return null;
        }
        return new TransitivePropertiesWrapper(props);
    }

    private static String makeClosureForProperty(Properties props, String propertyName, List<String> stack) {
        if (propertyName == null) {
            return null;
        }
        if (stack.contains(propertyName)) {
            throw new IllegalStateException("Loop detected on property " + propertyName + " " + stack);
        }
        stack.add(propertyName);
        String propertyValue = null;
        propertyValue = props instanceof TransitivePropertiesWrapper ? ((TransitivePropertiesWrapper)props).getRealProperty(propertyName) : props.getProperty(propertyName);
        if (propertyValue == null) {
            return null;
        }
        String toBeReplaced = TransitiveProperties.findPropertyToBeReplaced(propertyValue);
        while (toBeReplaced != null) {
            ArrayList<String> newStack = new ArrayList<String>(stack);
            String replaceValue = TransitiveProperties.makeClosureForProperty(props, toBeReplaced, newStack);
            propertyValue = replaceValue != null ? Replace.all(propertyValue, "${" + toBeReplaced + "}", replaceValue) : Replace.all(propertyValue, "${" + toBeReplaced + "}", "$(" + toBeReplaced + ")");
            toBeReplaced = TransitiveProperties.findPropertyToBeReplaced(propertyValue);
        }
        return propertyValue;
    }

    private static String findPropertyToBeReplaced(String text) {
        if (text == null) {
            return null;
        }
        int pos = text.lastIndexOf("${");
        if (pos < 0) {
            return null;
        }
        int pos2 = text.indexOf("}", pos);
        if (pos2 < 0) {
            return null;
        }
        return text.substring(pos + 2, pos2);
    }

    private static class TransitivePropertiesWrapper
    extends Properties {
        public TransitivePropertiesWrapper(Properties props) {
            this.putAll((Map<?, ?>)props);
        }

        public String getProperty(String key, String defaultValue) {
            String value = this.getProperty(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public String getProperty(String key) {
            String value = TransitiveProperties.makeClosureForProperty(this, key, new ArrayList());
            return value;
        }

        public String getRealProperty(String key) {
            return super.getProperty(key);
        }
    }
}

