/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops.alg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.SecureRandom;
import sk.antons.sprops.alg.SpropsAlg;
import sk.antons.sprops.model.SpropsData;
import sk.antons.sprops.security.Aes;
import sk.antons.sprops.security.Blowfish;
import sk.antons.sprops.security.Sha256;

public class SimpleAesSpropsAlg
implements SpropsAlg {
    private static final int IV = 1;
    private byte[] rawPassword;

    @Override
    public void password(byte[] password) {
        if (password == null) {
            throw new IllegalArgumentException("Bad password");
        }
        if (password.length == 0) {
            throw new IllegalArgumentException("Bad password");
        }
        this.rawPassword = password;
    }

    @Override
    public void password(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Bad password");
        }
        try {
            this.password(password.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad password - encoding", e);
        }
    }

    @Override
    public SpropsData prepare(byte[] data) {
        SpropsData sdata = new SpropsData();
        sdata.setData(data);
        SpropsData.Header header = new SpropsData.Header();
        header.addProperty(1, SimpleAesSpropsAlg.generateIV());
        sdata.setHeader(header);
        sdata.setData(data);
        return sdata;
    }

    @Override
    public byte[] encode(SpropsData data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bos);
            byte[] hashPass = Sha256.hash(this.rawPassword);
            byte[] header = data.getHeader().toByteArray();
            byte[] iv = data.getHeader().first(1).getValue();
            byte[] encodedData = Aes.encode(hashPass, iv, data.getData());
            byte[] encodedHeader = Blowfish.encode(hashPass, header);
            out.writeInt(encodedHeader.length);
            out.write(encodedHeader);
            out.write(encodedData);
            out.flush();
            out.close();
            byte[] rv = bos.toByteArray();
            bos.close();
            return rv;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to encode", e);
        }
    }

    @Override
    public SpropsData decode(byte[] data, int offset, int length) {
        try {
            SpropsData sdata = new SpropsData();
            ByteArrayInputStream bis = new ByteArrayInputStream(data, offset, length);
            DataInputStream in = new DataInputStream(bis);
            byte[] hashPass = Sha256.hash(this.rawPassword);
            int headerLength = in.readInt();
            byte[] encodedHeader = in.readNBytes(headerLength);
            byte[] encodedData = in.readAllBytes();
            byte[] decodedHeader = Blowfish.decode(hashPass, encodedHeader);
            SpropsData.Header header = SpropsData.Header.fromByteArray(decodedHeader, 0, decodedHeader.length);
            sdata.setHeader(header);
            byte[] iv = sdata.getHeader().first(1).getValue();
            byte[] decodedData = Aes.decode(hashPass, iv, encodedData);
            sdata.setData(decodedData);
            return sdata;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to decode", e);
        }
    }

    private static byte[] generateIV() {
        try {
            int ivSize = 16;
            byte[] iv = new byte[ivSize];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            return iv;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate IV", e);
        }
    }
}

