/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha256 {
    public static byte[] hash(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new IllegalArgumentException("Unable to compute hash from null bytes");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(bytes, offset, length);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to access SHA-256 algoritm", e);
        }
    }

    public static byte[] hash(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Unable to compute hash from null bytes");
        }
        return Sha256.hash(bytes, 0, bytes.length);
    }

    public static byte[] hash(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Unable to compute hash from null bytes");
        }
        try {
            return Sha256.hash(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to get UTF-8 bytes from string", e);
        }
    }
}

