/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops.tool;

import java.io.Console;
import java.io.File;
import java.util.logging.Logger;
import sk.antons.jaul.util.TextFile;
import sk.antons.sprops.tool.Args;
import sk.antons.sprops.tool.Command;
import sk.antons.sprops.tool.DecodeCommand;
import sk.antons.sprops.tool.EncodeCommand;
import sk.antons.sprops.tool.FileDecodeAllCommand;
import sk.antons.sprops.tool.FileDecodeCommand;
import sk.antons.sprops.tool.FileEncodeAllCommand;
import sk.antons.sprops.tool.FileEncodeCommand;
import sk.antons.sprops.tool.FileShowCommand;
import sk.antons.sprops.tool.HelpCommand;
import sk.antons.sprops.tool.NoCommand;
import sk.antons.sprops.tool.Resolved;
import sk.antons.util.logging.conf.SLConf;

public class Main {
    private static Logger log = Logger.getLogger("main");

    private static Command resolve(Args args) {
        if (args.isSet("-h", "-help", "--help")) {
            return new HelpCommand();
        }
        if (args.isSet("-encode", "--encode")) {
            return new EncodeCommand();
        }
        if (args.isSet("-decode", "--decode")) {
            return new DecodeCommand();
        }
        if (args.isSet("-fencode", "--fencode")) {
            return new FileEncodeCommand();
        }
        if (args.isSet("-fencodeall", "--fencodeall")) {
            return new FileEncodeAllCommand();
        }
        if (args.isSet("-fdecode", "--fdecode")) {
            return new FileDecodeCommand();
        }
        if (args.isSet("-fdecodeall", "--fdecodeall")) {
            return new FileDecodeAllCommand();
        }
        if (args.isSet("-fshow", "--fshow")) {
            return new FileShowCommand();
        }
        return null;
    }

    private static void process(Args args) {
        boolean result;
        File f;
        Command command = Main.resolve(args);
        if (command == null) {
            log.warning("Unable to resolve concrete command from arguments");
            command = new NoCommand();
        } else {
            log.info("command to execute " + command.getClass().getSimpleName());
        }
        String file = args.first("-fp", "-fpassword");
        if (!(file == null || (f = new File(file)).exists() && f.isFile())) {
            log.warning("Unable to resolve password file '" + file + "'");
            command = new HelpCommand();
        }
        if (!((file = args.first("-f", "-file")) == null || (f = new File(file)).exists() && f.isFile())) {
            log.warning("Unable to resolve properties file '" + file + "'");
            command = new HelpCommand();
        }
        if (!command.checkInput(args)) {
            log.warning("Input check failed for resolved command");
            command = new NoCommand();
        }
        Resolved.algorithm(args.first("-alg", "--alg"));
        if (command.requirePassword()) {
            if (args.isSet("-p", "-password")) {
                Resolved.password(args.first("-p", "--password"));
            } else if (args.isSet("-fp", "--fpassword")) {
                Resolved.password(TextFile.read(args.first("-fp", "--fpassword"), "utf-8"));
            } else {
                Console console = System.console();
                if (console == null) {
                    log.warning("Couldn't get Console instance");
                    System.exit(0);
                }
                char[] passwordArray = console.readPassword("Enter password: ", new Object[0]);
                Resolved.password(new String(passwordArray));
            }
        }
        if (result = command.realize(args)) {
            log.info("command " + command.getClass().getSimpleName() + " execution done.");
        } else {
            log.info("command " + command.getClass().getSimpleName() + " execution failed.");
        }
    }

    public static void main(String[] params) {
        SLConf.reset();
        SLConf.rootLogger().console().filterAll().pattern().text(" ").level(3, -3).text(" ").simpleName(-6, -6).text(" ").message().patternEnd().handler();
        SLConf.rootLogger().info();
        Args args = Args.instance().single("-h").single("-help").single("--help").pair("-p").pair("--password").pair("-fp").pair("--fpassword").pair("-alg").pair("--alg").single("-encode").pair("--encode").single("-decode").pair("--decode").pair("-fencode").pair("--fencode").pair("-fencodeall").pair("--fencodeall").pair("-fdecode").pair("--fdecode").pair("-fdecodeall").pair("--fdecodeall").pair("-fshow").pair("--fshow").parse(params);
        Main.process(args);
    }
}

