/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.util.logging.appender;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.LogRecord;
import sk.antons.util.logging.appender.AbstractAppender;

public class TimeAppender
extends AbstractAppender {
    private long starttime = 0L;
    private long endtime = 0L;
    private static Map<Long, String> twoCache = new Hashtable<Long, String>();
    private static Map<Long, String> threeCache = new Hashtable<Long, String>();

    private String two(long num) {
        String rv = twoCache.get(num);
        if (rv != null) {
            return rv;
        }
        rv = String.valueOf(num);
        if (num < 10L) {
            rv = "0" + rv;
        }
        twoCache.put(num, rv);
        return rv;
    }

    private String three(long num) {
        String rv = threeCache.get(num);
        if (rv != null) {
            return rv;
        }
        rv = String.valueOf(num);
        if (num < 10L) {
            rv = "0" + rv;
        }
        if (num < 100L) {
            rv = "0" + rv;
        }
        threeCache.put(num, rv);
        return rv;
    }

    private synchronized String time(long millis) {
        if (this.starttime < millis && millis >= this.endtime) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(millis);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            this.starttime = c.getTime().getTime();
            c.add(5, 1);
            this.endtime = c.getTime().getTime();
        }
        long tm = millis - this.starttime;
        long ms = tm % 1000L;
        long s = (tm /= 1000L) % 60L;
        long m = (tm /= 60L) % 60L;
        long h = (tm /= 60L) % 24L;
        StringBuilder sb = new StringBuilder();
        sb.append(this.two(h));
        sb.append(':');
        sb.append(this.two(m));
        sb.append(':');
        sb.append(this.two(s));
        sb.append('.');
        sb.append(this.three(ms));
        return sb.toString();
    }

    protected String format(LogRecord record) {
        if (record == null) {
            return null;
        }
        return this.time(record.getMillis());
    }
}

