/*
 * Decompiled with CFR 0.152.
 */
package refdiff.parsers.java;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import refdiff.core.cst.CstNode;
import refdiff.core.cst.CstNodeRelationship;
import refdiff.core.cst.CstNodeRelationshipType;
import refdiff.core.cst.CstRoot;
import refdiff.core.cst.HasChildrenNodes;
import refdiff.core.cst.Location;
import refdiff.core.cst.Parameter;
import refdiff.core.cst.Stereotype;

public class SDModel {
    private int nodeCounter = 0;
    private CstRoot root = new CstRoot();
    private Map<String, CstNode> keyMap = new HashMap<String, CstNode>();

    public Optional<CstNode> findByKey(String referencedKey) {
        return Optional.ofNullable(this.keyMap.get(referencedKey));
    }

    public void addReference(CstNode caller, CstNode calleeNode) {
        this.root.getRelationships().add(new CstNodeRelationship(CstNodeRelationshipType.USE, caller.getId(), calleeNode.getId()));
    }

    public void addSubtype(CstNode supertype, CstNode type) {
        this.root.getRelationships().add(new CstNodeRelationship(CstNodeRelationshipType.SUBTYPE, type.getId(), supertype.getId()));
    }

    public CstNode createInnerType(String typeName, HasChildrenNodes parent, String sourceFilePath, CharSequence fileContent, AbstractTypeDeclaration ast, String nodeType) {
        return this.createType(typeName, "", parent, sourceFilePath, fileContent, ast, nodeType);
    }

    public CstNode createType(String typeName, String packageName, HasChildrenNodes parent, String sourceFilePath, CharSequence fileContent, AbstractTypeDeclaration ast, String nodeType) {
        if (typeName == null || typeName.isEmpty()) {
            throw new RuntimeException("Type should have a name");
        }
        String namespace = packageName.isEmpty() ? "" : packageName + ".";
        CstNode cstNode = new CstNode(++this.nodeCounter);
        cstNode.setType(nodeType);
        cstNode.setLocation(Location.of((String)sourceFilePath, (int)ast.getStartPosition(), (int)(ast.getStartPosition() + ast.getLength()), (int)ast.getStartPosition(), (int)(ast.getStartPosition() + ast.getLength()), (CharSequence)fileContent));
        cstNode.setLocalName(typeName);
        cstNode.setSimpleName(typeName);
        cstNode.setNamespace(namespace);
        parent.addNode(cstNode);
        ITypeBinding binding = ast.resolveBinding();
        if (binding != null) {
            this.keyMap.put(binding.getKey(), cstNode);
        }
        return cstNode;
    }

    public CstNode createMethod(String methodSignature, HasChildrenNodes parent, String sourceFilePath, CharSequence fileContent, boolean constructor, MethodDeclaration ast) {
        int bodyLength;
        int bodyStart;
        Block body;
        String methodName = ast.isConstructor() ? "new" : ast.getName().getIdentifier();
        CstNode cstNode = new CstNode(++this.nodeCounter);
        cstNode.setType(ast.getClass().getSimpleName());
        if (constructor) {
            cstNode.addStereotypes(Stereotype.TYPE_CONSTRUCTOR);
        }
        if ((body = ast.getBody()) == null) {
            cstNode.addStereotypes(Stereotype.ABSTRACT);
            bodyStart = ast.getStartPosition() + ast.getLength();
            bodyLength = 0;
        } else {
            bodyStart = body.getStartPosition() + 1;
            bodyLength = body.getLength() - 2;
        }
        cstNode.setLocation(Location.of((String)sourceFilePath, (int)ast.getStartPosition(), (int)(ast.getStartPosition() + ast.getLength()), (int)bodyStart, (int)(bodyStart + bodyLength), (CharSequence)fileContent));
        cstNode.setLocalName(methodSignature);
        cstNode.setSimpleName(methodName);
        parent.addNode(cstNode);
        IMethodBinding binding = ast.resolveBinding();
        if (binding != null) {
            this.keyMap.put(binding.getKey(), cstNode);
        }
        return cstNode;
    }

    public void setReturnType(CstNode method, String normalizeTypeName) {
    }

    public void addParameter(CstNode method, String identifier, String typeName) {
        method.getParameters().add(new Parameter(identifier));
    }

    public CstRoot getRoot() {
        return this.root;
    }
}

