/*
 * Decompiled with CFR 0.152.
 */
package refdiff.parsers.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import refdiff.core.cst.CstNode;
import refdiff.core.cst.CstRoot;
import refdiff.core.cst.Stereotype;
import refdiff.core.io.FilePathFilter;
import refdiff.core.io.SourceFile;
import refdiff.core.io.SourceFileSet;
import refdiff.parsers.LanguagePlugin;
import refdiff.parsers.java.AstUtils;
import refdiff.parsers.java.JavaSourceTokenizer;
import refdiff.parsers.java.SDModel;
import refdiff.parsers.java.SDModelBuilder;

public class JavaPlugin
implements LanguagePlugin {
    private File tempDir = null;
    private final JavaSourceTokenizer tokenizer = new JavaSourceTokenizer();

    public JavaPlugin() {
    }

    public JavaPlugin(File tempDir) {
        this.tempDir = tempDir;
    }

    public CstRoot parse(SourceFileSet sources) throws Exception {
        ArrayList<String> javaFiles = new ArrayList<String>();
        Optional optBasePath = sources.getBasePath();
        if (!optBasePath.isPresent()) {
            if (this.tempDir == null) {
                throw new RuntimeException("The JavaParser requires a SourceFileSet that is materialized on the file system. Either pass a tempDir to JavaParser's contructor or call SourceFileSet::materializeAt before calling this method.");
            }
            sources.materializeAtBase(this.tempDir.toPath());
            optBasePath = sources.getBasePath();
        }
        for (SourceFile sourceFile : sources.getSourceFiles()) {
            javaFiles.add(sourceFile.getPath());
        }
        File rootFolder = ((Path)optBasePath.get()).toFile();
        SDModel sdModel = new SDModel();
        SDModelBuilder mb = new SDModelBuilder();
        mb.analyze(rootFolder, javaFiles, sdModel, this.tokenizer);
        return sdModel.getRoot();
    }

    public static String getKey(CstNode node) {
        String parentName = node.getParent().isPresent() ? JavaPlugin.getKey((CstNode)node.getParent().get()) + "." : (node.getNamespace() != null ? node.getNamespace() : "");
        if (node.getType().equals("MethodDeclaration")) {
            String key = parentName + AstUtils.normalizeMethodSignature(node.getLocalName());
            if (node.hasStereotype(Stereotype.TYPE_CONSTRUCTOR)) {
                key = key.replace(".new(", "." + ((CstNode)node.getParent().get()).getSimpleName() + "(");
            }
            return key;
        }
        return parentName + node.getLocalName();
    }

    public FilePathFilter getAllowedFilesFilter() {
        return new FilePathFilter(Arrays.asList(".java"));
    }
}

