/*
 * Decompiled with CFR 0.152.
 */
package refdiff.parsers.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.internal.compiler.util.Util;
import refdiff.core.cst.CstNode;
import refdiff.core.cst.TokenizedSource;
import refdiff.parsers.java.BindingsRecoveryAstVisitor;
import refdiff.parsers.java.JavaSourceTokenizer;
import refdiff.parsers.java.SDModel;

public class SDModelBuilder {
    private static final String systemFileSeparator = Matcher.quoteReplacement(File.separator);
    private Map<CstNode, List<String>> postProcessReferences;
    private Map<CstNode, List<String>> postProcessSupertypes;

    private void postProcessReferences(SDModel model, Map<CstNode, List<String>> referencesMap) {
        for (Map.Entry<CstNode, List<String>> entry : referencesMap.entrySet()) {
            CstNode entity = entry.getKey();
            List<String> references = entry.getValue();
            for (String referencedKey : references) {
                Optional<CstNode> referenced = model.findByKey(referencedKey);
                if (!referenced.isPresent()) continue;
                model.addReference(entity, referenced.get());
            }
        }
    }

    private void postProcessSupertypes(SDModel model) {
        for (Map.Entry<CstNode, List<String>> entry : this.postProcessSupertypes.entrySet()) {
            CstNode type = entry.getKey();
            List<String> supertypes = entry.getValue();
            for (String supertypeKey : supertypes) {
                Optional<CstNode> supertype = model.findByKey(supertypeKey);
                if (!supertype.isPresent()) continue;
                model.addSubtype(supertype.get(), type);
            }
        }
    }

    public void analyze(File rootFolder, List<String> javaFiles, final SDModel model, final JavaSourceTokenizer tokenizer) {
        this.postProcessReferences = new HashMap<CstNode, List<String>>();
        this.postProcessSupertypes = new HashMap<CstNode, List<String>>();
        final String projectRoot = rootFolder.getPath();
        String[] emptyArray = new String[]{};
        final String encoding = StandardCharsets.UTF_8.name();
        String[] filesArray = new String[javaFiles.size()];
        String[] encodings = new String[javaFiles.size()];
        for (int i = 0; i < filesArray.length; ++i) {
            filesArray[i] = rootFolder + File.separator + javaFiles.get(i).replaceAll("/", systemFileSeparator);
            encodings[i] = encoding;
        }
        String[] sourceFolders = this.inferSourceFolders(filesArray);
        ASTParser parser = SDModelBuilder.buildAstParser(sourceFolders);
        FileASTRequestor fileASTRequestor = new FileASTRequestor(){

            public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                String relativePath = sourceFilePath.substring(projectRoot.length() + 1).replaceAll(systemFileSeparator, "/");
                try {
                    char[] charArray = Util.getFileCharContent((File)new File(sourceFilePath), (String)encoding);
                    SDModelBuilder.this.processCompilationUnit(relativePath, charArray, ast, model);
                    TokenizedSource tokenizedSource = new TokenizedSource(relativePath, tokenizer.tokenize(charArray));
                    model.getRoot().addTokenizedFile(tokenizedSource);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        parser.createASTs(filesArray, encodings, emptyArray, fileASTRequestor, null);
        this.postProcessReferences(model, this.postProcessReferences);
        this.postProcessReferences = null;
        this.postProcessSupertypes(model);
        this.postProcessSupertypes = null;
    }

    private static ASTParser buildAstParser(String[] sourceFolders) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(8);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        parser.setCompilerOptions((Map)options);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setEnvironment(new String[0], sourceFolders, null, true);
        return parser;
    }

    private void processCompilationUnit(String sourceFilePath, char[] fileContent, CompilationUnit compilationUnit, SDModel model) {
        int flags;
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        String packageName = "";
        if (packageDeclaration != null) {
            packageName = packageDeclaration.getName().getFullyQualifiedName();
        }
        if (((flags = compilationUnit.getFlags()) & 8) <= 1 && (flags & 1) <= 1) {
            BindingsRecoveryAstVisitor visitor = new BindingsRecoveryAstVisitor(model, compilationUnit, sourceFilePath, fileContent, packageName, this.postProcessReferences, this.postProcessSupertypes);
            compilationUnit.accept((ASTVisitor)visitor);
        }
    }

    private String[] inferSourceFolders(String[] filesArray) {
        TreeSet<String> sourceFolders = new TreeSet<String>();
        block0: for (String file : filesArray) {
            for (String sourceFolder : sourceFolders) {
                if (!file.startsWith(sourceFolder)) continue;
                continue block0;
            }
            String otherSourceFolder = this.extractSourceFolderFromPath(file);
            if (otherSourceFolder == null) continue;
            sourceFolders.add(otherSourceFolder);
        }
        return sourceFolders.toArray(new String[sourceFolders.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractSourceFolderFromPath(String sourceFilePath) {
        try (BufferedReader scanner = new BufferedReader(new FileReader(sourceFilePath));){
            String lineFromFile;
            do {
                if ((lineFromFile = scanner.readLine()) == null) return null;
            } while (!lineFromFile.startsWith("package "));
            String packageName = lineFromFile.substring(8, lineFromFile.indexOf(59));
            String packagePath = packageName.replace('.', File.separator.charAt(0));
            int indexOfPackagePath = sourceFilePath.lastIndexOf(packagePath + File.separator);
            if (indexOfPackagePath >= 0) {
                String string = sourceFilePath.substring(0, indexOfPackagePath - 1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

