/*
 * Decompiled with CFR 0.152.
 */
package refdiff.parsers.java;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import refdiff.core.cst.CstNode;
import refdiff.core.cst.HasChildrenNodes;
import refdiff.core.cst.Stereotype;
import refdiff.parsers.java.AstUtils;
import refdiff.parsers.java.DependenciesAstVisitor;
import refdiff.parsers.java.SDModel;
import refdiff.parsers.java.Visibility;

public class BindingsRecoveryAstVisitor
extends ASTVisitor {
    private final SDModel model;
    private final String sourceFilePath;
    private final CharSequence fileContent;
    private final String packageName;
    private final LinkedList<HasChildrenNodes> containerStack;
    private final Map<CstNode, List<String>> postProcessReferences;
    private final Map<CstNode, List<String>> postProcessSupertypes;

    public BindingsRecoveryAstVisitor(SDModel model, CompilationUnit compilationUnit, String sourceFilePath, char[] fileContent, String packageName, Map<CstNode, List<String>> postProcessReferences, Map<CstNode, List<String>> postProcessSupertypes) {
        this.model = model;
        this.sourceFilePath = sourceFilePath;
        this.fileContent = CharBuffer.wrap(fileContent);
        this.packageName = packageName;
        this.containerStack = new LinkedList();
        this.containerStack.push((HasChildrenNodes)model.getRoot());
        this.postProcessReferences = postProcessReferences;
        this.postProcessSupertypes = postProcessSupertypes;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        this.containerStack.push((HasChildrenNodes)this.visitTypeDeclaration((AbstractTypeDeclaration)node, node.superInterfaceTypes(), "EnumDeclaration"));
        return true;
    }

    public void endVisit(EnumDeclaration node) {
        this.containerStack.pop();
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        ArrayList<Type> supertypes = new ArrayList<Type>();
        Type superclass = typeDeclaration.getSuperclassType();
        if (superclass != null) {
            supertypes.add(superclass);
        }
        supertypes.addAll(typeDeclaration.superInterfaceTypes());
        CstNode sdType = this.visitTypeDeclaration((AbstractTypeDeclaration)typeDeclaration, supertypes, typeDeclaration.isInterface() ? "InterfaceDeclaration" : "ClassDeclaration");
        this.containerStack.push((HasChildrenNodes)sdType);
        if (typeDeclaration.isInterface()) {
            sdType.addStereotypes(Stereotype.ABSTRACT);
        }
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.containerStack.pop();
    }

    private CstNode visitTypeDeclaration(AbstractTypeDeclaration node, List<Type> supertypes, String nodeType) {
        String typeName = node.getName().getIdentifier();
        CstNode type = node.isPackageMemberTypeDeclaration() ? this.model.createType(typeName, this.packageName, this.containerStack.peek(), this.sourceFilePath, this.fileContent, node, nodeType) : this.model.createInnerType(typeName, this.containerStack.peek(), this.sourceFilePath, this.fileContent, node, nodeType);
        Set<String> annotations = BindingsRecoveryAstVisitor.extractAnnotationTypes(node.modifiers());
        if (annotations.contains("Deprecated")) {
            type.addStereotypes(Stereotype.DEPRECATED);
        }
        for (Type superType : supertypes) {
            ITypeBinding superTypeBinding = superType.resolveBinding();
            this.extractSupertypesForPostProcessing(type, superTypeBinding);
        }
        return type;
    }

    private void extractSupertypesForPostProcessing(CstNode type, ITypeBinding superTypeBinding) {
        List<String> supertypes = this.postProcessSupertypes.get(type);
        if (supertypes == null) {
            supertypes = new ArrayList<String>();
            this.postProcessSupertypes.put(type, supertypes);
        }
        while (superTypeBinding != null && superTypeBinding.isFromSource()) {
            String superTypeName = superTypeBinding.getErasure().getKey();
            supertypes.add(superTypeName);
            superTypeBinding = superTypeBinding.getSuperclass();
        }
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        boolean deprecated;
        String methodSignature = AstUtils.getSignatureFromMethodDeclaration(methodDeclaration);
        CstNode method = this.model.createMethod(methodSignature, this.containerStack.peek(), this.sourceFilePath, this.fileContent, methodDeclaration.isConstructor(), methodDeclaration);
        List modifiers = methodDeclaration.modifiers();
        Set<String> annotations = BindingsRecoveryAstVisitor.extractAnnotationTypes(modifiers);
        boolean bl = deprecated = annotations.contains("Deprecated") || AstUtils.containsDeprecatedTag(methodDeclaration.getJavadoc());
        if (deprecated) {
            method.addStereotypes(Stereotype.DEPRECATED);
        }
        if (!methodDeclaration.isConstructor()) {
            method.addStereotypes(Stereotype.TYPE_MEMBER);
        }
        BindingsRecoveryAstVisitor.extractParametersAndReturnType(this.model, methodDeclaration, method);
        if (AstUtils.isGetter(methodDeclaration)) {
            method.addStereotypes(Stereotype.FIELD_ACCESSOR);
        } else if (AstUtils.isSetter(methodDeclaration)) {
            method.addStereotypes(Stereotype.FIELD_MUTATOR);
        }
        Block body = methodDeclaration.getBody();
        if (body == null) {
            method.addStereotypes(Stereotype.ABSTRACT);
        } else {
            final ArrayList references = new ArrayList();
            body.accept((ASTVisitor)new DependenciesAstVisitor(true){

                @Override
                protected void onMethodAccess(ASTNode node, IMethodBinding binding) {
                    String methodKey = binding.getKey();
                    references.add(methodKey);
                }
            });
            this.postProcessReferences.put(method, references);
        }
        return true;
    }

    private Visibility getVisibility(int methodModifiers) {
        Visibility visibility = (methodModifiers & 1) != 0 ? Visibility.PUBLIC : ((methodModifiers & 4) != 0 ? Visibility.PROTECTED : ((methodModifiers & 2) != 0 ? Visibility.PRIVATE : Visibility.PACKAGE));
        return visibility;
    }

    private static Set<String> extractAnnotationTypes(List<?> modifiers) {
        HashSet<String> annotations = new HashSet<String>();
        for (Object modifier : modifiers) {
            if (!(modifier instanceof Annotation)) continue;
            Annotation a = (Annotation)modifier;
            annotations.add(a.getTypeName().toString());
        }
        return annotations;
    }

    public static void extractParametersAndReturnType(SDModel model, MethodDeclaration methodDeclaration, CstNode method) {
        Type returnType = methodDeclaration.getReturnType2();
        if (returnType != null) {
            model.setReturnType(method, AstUtils.normalizeTypeName(returnType, methodDeclaration.getExtraDimensions(), false));
        } else {
            model.setReturnType(method, null);
        }
        for (SingleVariableDeclaration parameter : methodDeclaration.parameters()) {
            Type parameterType = parameter.getType();
            String typeName = AstUtils.normalizeTypeName(parameterType, parameter.getExtraDimensions(), parameter.isVarargs());
            model.addParameter(method, parameter.getName().getIdentifier(), typeName);
        }
    }
}

