/*
 * Decompiled with CFR 0.152.
 */
package refdiff.parsers.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public abstract class DependenciesAstVisitor
extends ASTVisitor {
    private boolean onlyFromSource = false;

    public DependenciesAstVisitor(boolean onlyFromSource) {
        this.onlyFromSource = onlyFromSource;
    }

    public final boolean visit(MethodInvocation node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        if (methodBinding != null) {
            this.handleTypeBinding((ASTNode)node, methodBinding.getDeclaringClass(), false);
            this.handleMethodBinding((ASTNode)node, methodBinding);
        }
        return true;
    }

    public final boolean visit(FieldAccess node) {
        IVariableBinding fieldBinding = node.resolveFieldBinding();
        if (fieldBinding != null) {
            this.handleTypeBinding((ASTNode)node, fieldBinding.getDeclaringClass(), false);
            this.handleFieldBinding((ASTNode)node, fieldBinding);
        }
        return true;
    }

    public boolean visit(SuperFieldAccess node) {
        IVariableBinding fieldBinding = node.resolveFieldBinding();
        if (fieldBinding != null) {
            this.handleTypeBinding((ASTNode)node, fieldBinding.getDeclaringClass(), false);
            this.handleFieldBinding((ASTNode)node, fieldBinding);
        }
        return true;
    }

    public final boolean visit(SimpleName node) {
        return this.visitNameNode((Name)node);
    }

    public final boolean visit(QualifiedName node) {
        return this.visitNameNode((Name)node);
    }

    private boolean visitNameNode(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBindig = (IVariableBinding)binding;
            if (variableBindig.isField()) {
                ITypeBinding declaringClass = variableBindig.getDeclaringClass();
                this.handleTypeBinding((ASTNode)node, declaringClass, false);
                this.handleFieldBinding((ASTNode)node, variableBindig);
            } else if (!variableBindig.isEnumConstant()) {
                this.handleVariableBinding((ASTNode)node, variableBindig);
            }
        }
        return true;
    }

    public final boolean visit(ClassInstanceCreation node) {
        ITypeBinding typeBinding = node.getType().resolveBinding();
        this.handleTypeBinding((ASTNode)node, typeBinding, true);
        return true;
    }

    public final boolean visit(VariableDeclarationStatement node) {
        ITypeBinding typeBinding = node.getType().resolveBinding();
        this.handleTypeBinding((ASTNode)node, typeBinding, true);
        return true;
    }

    public final boolean visit(CatchClause node) {
        ITypeBinding typeBinding = node.getException().getType().resolveBinding();
        this.handleTypeBinding((ASTNode)node, typeBinding, true);
        return true;
    }

    public final boolean visit(MarkerAnnotation node) {
        ITypeBinding typeBinding = node.getTypeName().resolveTypeBinding();
        this.handleTypeBinding((ASTNode)node, typeBinding, true);
        return true;
    }

    public final boolean visit(CastExpression node) {
        Type type = node.getType();
        this.handleTypeBinding((ASTNode)node, type.resolveBinding(), true);
        return true;
    }

    public final boolean visit(TypeLiteral node) {
        Type type = node.getType();
        this.handleTypeBinding((ASTNode)node, type.resolveBinding(), true);
        return true;
    }

    protected void onTypeAccess(ASTNode node, ITypeBinding binding) {
    }

    protected void onVariableAccess(ASTNode node, IVariableBinding binding) {
    }

    protected void onFieldAccess(ASTNode node, IVariableBinding binding) {
    }

    protected void onMethodAccess(ASTNode node, IMethodBinding binding) {
    }

    private void handleTypeBinding(ASTNode node, ITypeBinding typeBinding, boolean includeTypeParameters) {
        if (typeBinding != null) {
            ArrayList<ITypeBinding> rawTypes = new ArrayList<ITypeBinding>();
            HashSet<String> dejavu = new HashSet<String>();
            this.appendRawTypes(rawTypes, dejavu, typeBinding, includeTypeParameters);
            for (ITypeBinding rawType : rawTypes) {
                if (this.ignoreType(rawType)) continue;
                this.onTypeAccess(node, rawType);
            }
        }
    }

    private void appendRawTypes(List<ITypeBinding> rawTypes, Set<String> dejavu, ITypeBinding typeBinding, boolean includeTypeParameters) {
        ITypeBinding[] typeBounds;
        ITypeBinding[] typeArguments;
        String key = typeBinding.getKey();
        if (dejavu.contains(key)) {
            return;
        }
        dejavu.add(key);
        ITypeBinding erasure = typeBinding.getErasure();
        rawTypes.add(erasure);
        if (!includeTypeParameters) {
            return;
        }
        ITypeBinding elementType = typeBinding.getElementType();
        if (elementType != null) {
            this.appendRawTypes(rawTypes, dejavu, elementType, includeTypeParameters);
        }
        if ((typeArguments = typeBinding.getTypeArguments()) != null) {
            for (ITypeBinding typeArgument : typeArguments) {
                this.appendRawTypes(rawTypes, dejavu, typeArgument, includeTypeParameters);
            }
        }
        if ((typeBounds = typeBinding.getTypeBounds()) != null) {
            for (ITypeBinding typeBound : typeBounds) {
                this.appendRawTypes(rawTypes, dejavu, typeBound, includeTypeParameters);
            }
        }
    }

    private void handleVariableBinding(ASTNode node, IVariableBinding variableBindig) {
        if (variableBindig != null) {
            this.onVariableAccess(node, variableBindig);
        }
    }

    private void handleFieldBinding(ASTNode node, IVariableBinding variableBindig) {
        ITypeBinding declaringClass;
        if (variableBindig != null && (declaringClass = variableBindig.getDeclaringClass()) != null && !this.ignoreType(declaringClass)) {
            this.onFieldAccess(node, variableBindig);
        }
    }

    private void handleMethodBinding(ASTNode node, IMethodBinding methodBinding) {
        ITypeBinding declaringClass;
        if (methodBinding != null && (declaringClass = methodBinding.getDeclaringClass()) != null && !this.ignoreType(declaringClass)) {
            this.onMethodAccess(node, methodBinding);
        }
    }

    protected boolean ignoreType(ITypeBinding typeBinding) {
        return this.onlyFromSource && !typeBinding.isFromSource();
    }
}

