/*
 * Decompiled with CFR 0.152.
 */
package refdiff.parsers.java;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import refdiff.core.cst.TokenPosition;

public class JavaSourceTokenizer {
    private IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (String)"1.8");
    private static Pattern pattern = Pattern.compile("\\S+");

    public List<TokenPosition> tokenize(char[] charArray) {
        try {
            int token;
            this.scanner.setSource(charArray);
            ArrayList<TokenPosition> tokens = new ArrayList<TokenPosition>();
            while ((token = this.scanner.getNextToken()) != 158) {
                int tokenStart = this.scanner.getCurrentTokenStartPosition();
                int tokenEnd = this.scanner.getCurrentTokenEndPosition();
                if (token == 1001 || token == 1002 || token == 1003) {
                    JavaSourceTokenizer.tokenizeComment(charArray, tokenStart, tokenEnd + 1, tokens);
                    continue;
                }
                if (!JavaSourceTokenizer.isSignificantToken(token)) continue;
                tokens.add(new TokenPosition(tokenStart, tokenEnd + 1));
            }
            return tokens;
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSignificantToken(int token) {
        return token != 1000;
    }

    private static void tokenizeComment(char[] charArray, int start, int end, List<TokenPosition> tokens) {
        CharBuffer comment = CharBuffer.wrap(charArray, start, end - start);
        Matcher matcher = pattern.matcher(comment);
        while (matcher.find()) {
            String token = matcher.group();
            if (token.equals("*")) continue;
            tokens.add(new TokenPosition(start + matcher.start(), start + matcher.end()));
        }
    }
}

