/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core;

import java.util.Optional;

public class Environment {
    public static final String ENVIRONMENT_VARIABLE_NOT_SET = "Environment variable not set: ";

    public Optional<String> readEnvOpt(String variableName) {
        return Optional.ofNullable(System.getenv().get(variableName)).filter(value -> !value.isBlank());
    }

    public String readEnv(String variableName) {
        return this.readEnvOpt(variableName).orElseThrow(() -> this.variableNotSetException(variableName));
    }

    private IllegalStateException variableNotSetException(String variableName) {
        return new IllegalStateException(ENVIRONMENT_VARIABLE_NOT_SET + variableName);
    }
}

