/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import org.zalando.problem.ProblemModule;

public final class JsonUtils {
    public static final ObjectMapper objectMapperNoEmpty = JsonUtils.createJsonParser(JsonInclude.Include.NON_EMPTY);
    public static final ObjectMapper objectMapperWithEmpty = JsonUtils.createJsonParser(JsonInclude.Include.ALWAYS);
    public static final ObjectMapper objectMapper = objectMapperNoEmpty;

    private JsonUtils() {
    }

    private static ObjectMapper createJsonParser(JsonInclude.Include includeEmptyValuesOption) {
        JsonFactory jsonFactory = new JsonFactory().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return new ObjectMapper(jsonFactory).registerModule((Module)new ProblemModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)JsonUtils.emptyStringAsNullModule()).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).enable(SerializationFeature.INDENT_OUTPUT).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(includeEmptyValuesOption);
    }

    private static SimpleModule emptyStringAsNullModule() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String.class, (JsonDeserializer)new StdDeserializer<String>(String.class){

            public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String result = StringDeserializer.instance.deserialize(p, ctxt);
                if (result == null || result.isEmpty()) {
                    return null;
                }
                return result;
            }
        });
        return module;
    }
}

