/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.attempt;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import nva.commons.core.attempt.ConsumerWithException;
import nva.commons.core.attempt.FunctionWithException;
import nva.commons.core.attempt.Try;

public class Failure<T>
extends Try<T> {
    private final Exception exception;

    public Failure(Exception exception) {
        this.exception = exception;
    }

    @Override
    public Stream<T> stream() {
        return Stream.empty();
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Result is a failure. Try getting the exception");
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public <S, E extends Exception> Try<S> map(FunctionWithException<T, S, E> action) {
        return new Failure<T>(this.exception);
    }

    @Override
    public <S, E extends Exception> Try<S> flatMap(FunctionWithException<T, Try<S>, E> action) {
        return new Failure<T>(this.exception);
    }

    @Override
    public <E extends Exception> T orElseThrow(Function<Failure<T>, E> action) throws E {
        if (action != null) {
            throw (Exception)action.apply(this);
        }
        throw new IllegalStateException("Action cannot be null");
    }

    @Override
    public T orElseThrow() {
        throw new RuntimeException(this.getException());
    }

    @Override
    public <E extends Exception> T orElse(FunctionWithException<Failure<T>, T, E> action) throws E {
        if (action != null) {
            return action.apply(this);
        }
        throw new IllegalStateException("Action cannot be null");
    }

    @Override
    public <E extends Exception> Optional<T> toOptional(ConsumerWithException<Failure<T>, E> action) throws E {
        action.consume(this);
        return Optional.empty();
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.empty();
    }

    @Override
    public <E extends Exception> Try<Void> forEach(ConsumerWithException<T, E> consumer) {
        return new Failure<Void>(this.exception);
    }
}

