/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.attempt;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Stream;
import nva.commons.core.attempt.ConsumerWithException;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.FunctionWithException;
import nva.commons.core.attempt.Success;

public abstract class Try<T> {
    public static final String NULL_ACTION_MESSAGE = "Action cannot be null";

    public static <T> Try<T> of(T input) {
        return new Success<T>(input);
    }

    public static <S> Try<S> attempt(Callable<S> action) {
        try {
            return new Success<S>(action.call());
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    public static <T, R, E extends Exception> Function<T, Try<R>> attempt(FunctionWithException<T, R, E> fe) {
        return arg -> {
            try {
                return new Success(fe.apply(arg));
            }
            catch (Exception e) {
                return new Failure(e);
            }
        };
    }

    public abstract Stream<T> stream();

    public abstract boolean isSuccess();

    public abstract T get();

    public abstract Exception getException();

    public final boolean isFailure() {
        return !this.isSuccess();
    }

    public abstract <S, E extends Exception> Try<S> map(FunctionWithException<T, S, E> var1);

    public abstract <S, E extends Exception> Try<S> flatMap(FunctionWithException<T, Try<S>, E> var1);

    public abstract <E extends Exception> Try<Void> forEach(ConsumerWithException<T, E> var1);

    public abstract <E extends Exception> T orElseThrow(Function<Failure<T>, E> var1) throws E;

    public abstract T orElseThrow();

    public abstract <E extends Exception> T orElse(FunctionWithException<Failure<T>, T, E> var1) throws E;

    public abstract <E extends Exception> Optional<T> toOptional(ConsumerWithException<Failure<T>, E> var1) throws E;

    public abstract Optional<T> toOptional();
}

