/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.ioutils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import nva.commons.core.ioutils.exceptions.FileNotFoundUncheckedException;
import nva.commons.core.ioutils.exceptions.ResourceNotFoundException;

public final class IoUtils {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String WIN_PATH_SEPARATOR_REGEX = "\\\\";
    public static final String PATH_SEPARATOR_FOR_RESOURCES = "/";

    private IoUtils() {
    }

    @Deprecated
    public static InputStream inputStreamFromResources(Path path) {
        String pathString = IoUtils.pathToString(path);
        return IoUtils.inputStreamFromResources(pathString);
    }

    public static String pathToString(Path path) {
        return IoUtils.replaceWinPathSeparatorsWithUniversalPathSeparators(path.toString());
    }

    public static InputStream inputStreamFromResources(String path) {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            IoUtils.requireResourceExists(stream);
            return stream;
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(path, e);
        }
    }

    public static String streamToString(InputStream stream) {
        String string;
        BufferedReader reader = new BufferedReader(IoUtils.newInputStreamReader(stream));
        try {
            string = reader.lines().collect(Collectors.joining(LINE_SEPARATOR));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return string;
    }

    public static String stringFromFile(Path path) {
        String string;
        block8: {
            InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                string = IoUtils.streamToString(fileInputStream);
                if (fileInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileNotFoundUncheckedException(path, e);
                }
            }
            fileInputStream.close();
        }
        return string;
    }

    public static List<String> linesfromResource(Path path) {
        List<String> list;
        BufferedReader reader = new BufferedReader(IoUtils.newInputStreamReader(IoUtils.inputStreamFromResources(path)));
        try {
            list = reader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return list;
    }

    public static String stringFromResources(Path path) {
        return IoUtils.streamToString(IoUtils.inputStreamFromResources(path));
    }

    public static InputStream stringToStream(String input) {
        return new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
    }

    private static String replaceWinPathSeparatorsWithUniversalPathSeparators(String path) {
        return path.replaceAll(WIN_PATH_SEPARATOR_REGEX, PATH_SEPARATOR_FOR_RESOURCES);
    }

    private static void requireResourceExists(InputStream stream) {
        Objects.requireNonNull(stream);
    }

    private static InputStreamReader newInputStreamReader(InputStream stream) {
        return new InputStreamReader(stream, StandardCharsets.UTF_8);
    }
}

