/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.useragent;

import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import nva.commons.core.useragent.InvalidUserAgentException;

public final class UserAgent {
    public static final String USER_AGENT = "User-Agent";
    private final String userAgentString;

    private UserAgent(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public static UserAgentBuilder newBuilder() {
        return new UserAgentBuilder();
    }

    public String toString() {
        return this.userAgentString;
    }

    public static class UserAgentBuilder {
        public static final String USER_AGENT_TEMPLATE = "%s-%s/%s (%s; mailto:%s)";
        public static final String NULL_VALUE_ERROR = "No value for user agent builder may be null";
        private String clientName;
        private String versionName;
        private URI uri;
        private String emailAddress;
        private String environmentName;

        private UserAgentBuilder() {
        }

        public UserAgentBuilder client(Class<?> aClass) {
            this.clientName = aClass.getSimpleName();
            return this;
        }

        public UserAgentBuilder version(String version) {
            this.versionName = version;
            return this;
        }

        public UserAgentBuilder repository(URI uri) {
            this.uri = uri;
            return this;
        }

        public UserAgentBuilder email(String email) {
            this.emailAddress = email;
            return this;
        }

        public UserAgentBuilder environment(String environment) {
            this.environmentName = environment;
            return this;
        }

        public UserAgent build() {
            this.validate(this.uri, this.clientName, this.environmentName, this.versionName, this.uri, this.emailAddress);
            String userAgentString = String.format(USER_AGENT_TEMPLATE, this.clientName, this.environmentName, this.versionName, this.uri, this.emailAddress);
            return new UserAgent(userAgentString);
        }

        private void validate(Object ... objects) {
            if (Arrays.stream(objects).anyMatch(Objects::isNull)) {
                throw new InvalidUserAgentException(NULL_VALUE_ERROR);
            }
        }
    }
}

