/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core;

import java.util.Objects;

public final class StringUtils {
    public static final String DOUBLE_WHITESPACE = "\\s\\s";
    public static final String WHITESPACES = "\\s+";
    public static final String SPACE = " ";
    public static final String EMPTY_STRING = "";

    private StringUtils() {
    }

    public static String removeMultipleWhiteSpaces(String input) {
        String buffer = input.trim();
        String result = buffer.replaceAll(DOUBLE_WHITESPACE, SPACE);
        while (!result.equals(buffer)) {
            buffer = result;
            result = buffer.replaceAll(DOUBLE_WHITESPACE, SPACE);
        }
        return result;
    }

    public static String removeWhiteSpaces(String input) {
        return input.replaceAll(WHITESPACES, EMPTY_STRING);
    }

    public static boolean isBlank(String input) {
        return Objects.isNull(input) || input.isBlank();
    }

    public static boolean isEmpty(String input) {
        return Objects.isNull(input) || input.isEmpty();
    }

    public static String replaceWhiteSpacesWithSpace(String str) {
        return str.replaceAll("\\s", SPACE);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }
}

