/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.language;

import java.net.URI;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nva.commons.core.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageMapper {
    public static final Map<String, String> IS02_TO_ISO3_CODES = LanguageMapper.hardCodedMappings();
    public static final String LEXVO_URI_PREFIX = "http://lexvo.org/id/iso639-3/";
    public static final URI LEXVO_URI_UNDEFINED = URI.create("http://lexvo.org/id/iso639-3/und");
    public static final String ERROR_MESSAGE_MISSING_RESOURCE_EXCEPTION = "Failing to retrieve URI for the language code ";
    private static final Logger logger = LoggerFactory.getLogger(LanguageMapper.class);

    private LanguageMapper() {
    }

    public static URI toUri(String languageCode) {
        return LanguageMapper.toIso3Code(languageCode).map(iso3 -> URI.create(LEXVO_URI_PREFIX + iso3)).orElse(LEXVO_URI_UNDEFINED);
    }

    private static Map<String, String> hardCodedMappings() {
        return Stream.of(new AbstractMap.SimpleEntry<String, String>("alb", "sqi"), new AbstractMap.SimpleEntry<String, String>("arm", "hye"), new AbstractMap.SimpleEntry<String, String>("baq", "eus"), new AbstractMap.SimpleEntry<String, String>("bur", "mya"), new AbstractMap.SimpleEntry<String, String>("chi", "zho"), new AbstractMap.SimpleEntry<String, String>("cze", "ces"), new AbstractMap.SimpleEntry<String, String>("dut", "nld"), new AbstractMap.SimpleEntry<String, String>("fre", "fra"), new AbstractMap.SimpleEntry<String, String>("geo", "kat"), new AbstractMap.SimpleEntry<String, String>("ger", "deu"), new AbstractMap.SimpleEntry<String, String>("gre", "ell"), new AbstractMap.SimpleEntry<String, String>("ice", "isl"), new AbstractMap.SimpleEntry<String, String>("mac", "mkd"), new AbstractMap.SimpleEntry<String, String>("mao", "mri"), new AbstractMap.SimpleEntry<String, String>("may", "msa"), new AbstractMap.SimpleEntry<String, String>("per", "fas"), new AbstractMap.SimpleEntry<String, String>("rum", "ron"), new AbstractMap.SimpleEntry<String, String>("slo", "slk"), new AbstractMap.SimpleEntry<String, String>("tib", "bod"), new AbstractMap.SimpleEntry<String, String>("wel", "cym")).collect(Collectors.toUnmodifiableMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private static Optional<String> toIso3Code(String languageCode) {
        try {
            return Optional.ofNullable(languageCode).filter(StringUtils::isNotBlank).map(LanguageMapper::returnHardCodedMappingIfExistsOrSameValue).map(Locale::new).map(Locale::getISO3Language);
        }
        catch (MissingResourceException e) {
            logger.warn(ERROR_MESSAGE_MISSING_RESOURCE_EXCEPTION + languageCode, (Throwable)e);
            return Optional.empty();
        }
    }

    private static String returnHardCodedMappingIfExistsOrSameValue(String code) {
        return IS02_TO_ISO3_CODES.getOrDefault(code, code);
    }
}

