/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.paths;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import nva.commons.core.paths.UnixPath;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public class UriWrapper {
    public static final String EMPTY_FRAGMENT = null;
    public static final String EMPTY_PATH = null;
    public static final String EMPTY_USER_INFO = null;
    public static final String EMPTY_QUERY = null;
    public static final String MISSING_HOST = "Missing host for creating URI";
    public static final String HTTPS = "https";
    public static final String NULL_INPUT_ERROR = "Input URI cannot be null.";
    private static final int VALUE = 1;
    private static final int DEFAULT_PORT = -1;
    private static final String AMPERSAND = "&";
    private static final String ASSIGNMENT = "=";
    private static final int NO_MATCH = -1;
    private URI uri;

    @Deprecated(forRemoval=true)
    @JacocoGenerated
    public UriWrapper(URI uri) {
        if (Objects.isNull(uri)) {
            throw new IllegalArgumentException(NULL_INPUT_ERROR);
        }
        this.uri = uri;
    }

    @Deprecated(forRemoval=true)
    @JacocoGenerated
    public UriWrapper(String uri) {
        this(URI.create(uri));
    }

    public UriWrapper(String scheme, String host) {
        this(UriWrapper.createUriWithSchemeAndHost(scheme, host, -1));
    }

    public static UriWrapper fromUri(URI uri) {
        return new UriWrapper(uri);
    }

    public static UriWrapper fromUri(String uri) {
        return new UriWrapper(URI.create(uri));
    }

    public static UriWrapper fromHost(String host) {
        return new UriWrapper(UriWrapper.createUriWithSchemeAndHost(HTTPS, host, -1));
    }

    public static UriWrapper fromHost(String host, int port) {
        return new UriWrapper(UriWrapper.createUriWithSchemeAndHost(HTTPS, host, port));
    }

    public URI getUri() {
        return this.uri;
    }

    public UriWrapper getHost() {
        return Try.attempt(() -> new URI(this.uri.getScheme(), this.uri.getHost(), EMPTY_PATH, EMPTY_FRAGMENT)).map(UriWrapper::new).orElseThrow();
    }

    public UriWrapper addChild(String ... path) {
        return this.addChild(UnixPath.of(path));
    }

    public UriWrapper addChild(UnixPath childPath) {
        UnixPath thisPath = this.getPath();
        UnixPath totalPath = thisPath.addChild(childPath).addRoot();
        return Try.attempt(() -> new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), totalPath.toString(), this.uri.getQuery(), EMPTY_FRAGMENT)).map(UriWrapper::new).orElseThrow();
    }

    public UriWrapper replacePathElementByIndexFromEnd(int index, String replacement) {
        UnixPath newPath = this.getPath().replacePathElementByIndexFromEnd(index, replacement);
        return Try.attempt(() -> new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), newPath.toString(), this.uri.getQuery(), this.uri.getFragment())).map(UriWrapper::new).orElseThrow();
    }

    public UnixPath toS3bucketPath() {
        return this.getPath().removeRoot();
    }

    public UnixPath getPath() {
        String pathString = this.uri.getPath();
        return UnixPath.of(pathString);
    }

    public Optional<UriWrapper> getParent() {
        return Optional.of(this.uri).map(URI::getPath).map(xva$0 -> UnixPath.of(xva$0)).flatMap(UnixPath::getParent).map(Try.attempt(p -> new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), p.toString(), EMPTY_QUERY, EMPTY_FRAGMENT))).map(Try::orElseThrow).map(UriWrapper::new);
    }

    public String getLastPathElement() {
        return this.getPath().getLastPathElement();
    }

    @Deprecated(since="getLastPathElement was introduced")
    @JacocoGenerated
    public String getFilename() {
        return this.getLastPathElement();
    }

    public UriWrapper addQueryParameter(String param, String value) {
        this.uri = Try.attempt(() -> new URIBuilder(this.uri).removeQuery().addParameters(this.extractUriQueryParameters()).addParameter(param, value).build()).orElseThrow();
        return this;
    }

    public UriWrapper addQueryParameters(Map<String, String> parameters) {
        UriWrapper uriWrapper = new UriWrapper(this.getUri());
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            uriWrapper = uriWrapper.addQueryParameter(e.getKey(), e.getValue());
        }
        return uriWrapper;
    }

    public String toString() {
        return this.getUri().toString();
    }

    private static URI createUriWithSchemeAndHost(String scheme, String host, int port) {
        return Try.attempt(() -> UriWrapper.createUriFromHostUri(scheme, host, port)).or(() -> UriWrapper.createUriFromHostDomain(scheme, host, port)).orElseThrow(fail -> new IllegalArgumentException(MISSING_HOST, fail.getException()));
    }

    private static URI createUriFromHostUri(String scheme, String host, int port) throws URISyntaxException {
        URI hostUri = URI.create(host);
        String hostString = hostUri.getHost();
        return UriWrapper.createUriFromHostDomain(scheme, hostString, port);
    }

    private static URI createUriFromHostDomain(String scheme, String host, int port) throws URISyntaxException {
        return new URI(scheme, EMPTY_USER_INFO, host, port, EMPTY_PATH, EMPTY_QUERY, EMPTY_FRAGMENT);
    }

    private static List<NameValuePair> extractKeyValuePairs(String query) {
        return Arrays.stream(UriWrapper.splitKeyValuePairs(query)).map(UriWrapper::createNameValuePair).toList();
    }

    private static NameValuePair createNameValuePair(String pairString) {
        int assignation = pairString.indexOf(ASSIGNMENT);
        if (assignation == -1) {
            return new BasicNameValuePair(UriWrapper.decode(pairString), null);
        }
        return new BasicNameValuePair(UriWrapper.decode(pairString.substring(0, assignation)), UriWrapper.decode(pairString.substring(assignation + 1)));
    }

    private static String decode(String encodedString) {
        return URLDecoder.decode(encodedString, StandardCharsets.UTF_8);
    }

    private static String[] splitKeyValuePairs(String query) {
        return query.split(AMPERSAND);
    }

    private List<NameValuePair> extractUriQueryParameters() {
        String query = this.uri.getRawQuery();
        return Objects.nonNull(query) ? UriWrapper.extractKeyValuePairs(query) : Collections.emptyList();
    }
}

