/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    public static final String ENVIRONMENT_VARIABLE_NOT_SET = "Environment variable not set: ";

    public Optional<String> readEnvOpt(String variableName) {
        return Optional.ofNullable(System.getenv().get(variableName)).filter(value -> !value.isBlank());
    }

    public String readEnv(String variableName) {
        return this.readEnvOpt(variableName).orElseThrow(() -> this.variableNotSetException(variableName));
    }

    private IllegalStateException variableNotSetException(String variableName) {
        String message = ENVIRONMENT_VARIABLE_NOT_SET + variableName;
        logger.error(message);
        return new IllegalStateException(message);
    }
}

