/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core.attempt;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Stream;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.ConsumerWithException;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.FunctionWithException;
import nva.commons.core.attempt.Try;

public class Success<T>
extends Try<T> {
    public final T value;

    public Success(T value) {
        this.value = value;
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.value);
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public Exception getException() {
        throw new IllegalStateException("Result is a success, no exception");
    }

    @Override
    public <S, E extends Exception> Try<S> map(FunctionWithException<T, S, E> mapper) {
        Objects.requireNonNull(mapper);
        return Success.attempt(() -> mapper.apply(this.value));
    }

    @Override
    public <S, E extends Exception> Try<S> flatMap(FunctionWithException<T, Try<S>, E> action) {
        try {
            return action.apply(this.value);
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    @Override
    public <E extends Exception> T orElseThrow(Function<Failure<T>, E> action) throws E {
        if (action == null) {
            throw new IllegalStateException("Action cannot be null");
        }
        return this.get();
    }

    @Override
    public T orElseThrow() {
        return this.get();
    }

    @Override
    public <E extends Exception> T orElse(FunctionWithException<Failure<T>, T, E> action) throws E {
        if (action == null) {
            throw new IllegalStateException("Action cannot be null");
        }
        return this.get();
    }

    @Override
    public <E extends Exception> Optional<T> toOptional(ConsumerWithException<Failure<T>, E> action) throws E {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Try<T> or(Callable<T> action) {
        return this;
    }

    @Override
    public <E extends Exception> Try<Void> forEach(ConsumerWithException<T, E> action) {
        try {
            action.consume(this.value);
            return new Success<Object>(null);
        }
        catch (Exception e) {
            return new Failure<Void>(e);
        }
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Success success = (Success)o;
        return Objects.equals(this.value, success.value);
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

